/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import java.util.ArrayList;
import java.util.Map;

public class ServiceEntryConverter
implements JsonCodec<ServiceEntry, JsonObject> {
    public static final ServiceEntryConverter INSTANCE = new ServiceEntryConverter();

    public JsonObject encode(ServiceEntry value) {
        return value != null ? value.toJson() : null;
    }

    public ServiceEntry decode(JsonObject value) {
        return value != null ? new ServiceEntry(value) : null;
    }

    public Class<ServiceEntry> getTargetClass() {
        return ServiceEntry.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceEntry obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "checks": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Check> list = new ArrayList<Check>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Check((JsonObject)item));
                        }
                    });
                    obj.setChecks(list);
                    break;
                }
                case "node": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNode(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "service": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setService(new Service((JsonObject)member.getValue()));
                }
            }
        }
    }

    public static void toJson(ServiceEntry obj, JsonObject json) {
        ServiceEntryConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ServiceEntry obj, Map<String, Object> json) {
        if (obj.getChecks() != null) {
            JsonArray array = new JsonArray();
            obj.getChecks().forEach(item -> array.add(item.toJson()));
            json.put("checks", array);
        }
        if (obj.getNode() != null) {
            json.put("node", obj.getNode().toJson());
        }
        if (obj.getService() != null) {
            json.put("service", obj.getService().toJson());
        }
    }
}

