/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.ProcedureException;
import java.util.List;

@DataObject
public class CheckResult {
    private List<CheckResult> checks;
    private String id;
    private Status status;
    private Throwable failure;

    public static CheckResult from(String name, Status status) {
        return new CheckResult().setId(name).setStatus(status);
    }

    public static CheckResult from(String name, Throwable e) {
        return new CheckResult().setId(name).setFailure(e);
    }

    public static boolean isUp(Future<CheckResult> json) {
        return !json.failed() && CheckResult.isUp((CheckResult)json.result());
    }

    public static boolean isUp(CheckResult json) {
        return json == null || json.getUp() != false;
    }

    public CheckResult setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public CheckResult setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Boolean getUp() {
        if (this.status != null) {
            return this.status.isOk();
        }
        if (this.failure != null) {
            return false;
        }
        List<CheckResult> checks = this.getChecks();
        if (checks != null) {
            for (CheckResult check : checks) {
                if (check.getUp().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public JsonObject getData() {
        if (this.status != null) {
            if (this.status.getData().isEmpty()) {
                return null;
            }
            return this.status.getData();
        }
        if (this.failure != null) {
            JsonObject data = new JsonObject();
            data.put("cause", (Object)this.failure.getMessage());
            if (this.failure instanceof ProcedureException) {
                data.put("procedure-execution-failure", (Object)true);
            }
            return data;
        }
        return null;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public CheckResult setFailure(Throwable failure) {
        this.failure = failure;
        return this;
    }

    public CheckResult setChecks(List<CheckResult> checks) {
        this.checks = checks;
        return this;
    }

    public List<CheckResult> getChecks() {
        return this.checks;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.id != null) {
            json.put("id", (Object)this.id);
        }
        json.put("status", (Object)(this.getUp() != false ? "UP" : "DOWN"));
        JsonObject data = this.getData();
        if (data != null) {
            json.put("data", (Object)data.copy());
        }
        if (this.status != null && this.status.isProcedureInError()) {
            json.put("error", (Object)true);
        }
        if (this.checks != null) {
            JsonArray array = new JsonArray();
            for (CheckResult check : this.checks) {
                JsonObject nested = check.toJson();
                nested.remove("outcome");
                array.add((Object)nested);
            }
            json.put("checks", (Object)array);
        }
        json.put("outcome", (Object)(this.getUp() != false ? "UP" : "DOWN"));
        return json;
    }
}

