/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.httpproxy.ProxyContext;
import java.util.function.Function;

@VertxGen
@FunctionalInterface
public interface OriginRequestProvider {
    public static OriginRequestProvider fixedAddress(int port, String host) {
        return OriginRequestProvider.fixedAddress(SocketAddress.inetSocketAddress((int)port, (String)host));
    }

    public static OriginRequestProvider fixedAddress(final SocketAddress address) {
        return new OriginRequestProvider(){

            @Override
            public Future<HttpClientRequest> create(ProxyContext proxyContext) {
                return proxyContext.client().request(new RequestOptions().setServer(address));
            }
        };
    }

    public static OriginRequestProvider selector(final Function<ProxyContext, Future<SocketAddress>> selector) {
        return new OriginRequestProvider(){

            @Override
            public Future<HttpClientRequest> create(ProxyContext proxyContext) {
                return ((Future)selector.apply(proxyContext)).flatMap(server -> proxyContext.client().request(new RequestOptions().setServer(server)));
            }
        };
    }

    public Future<HttpClientRequest> create(ProxyContext var1);
}

