/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;

class BufferingReadStream
implements ReadStream<Buffer> {
    private final ReadStream<Buffer> stream;
    private final Buffer content;
    private Handler<Void> endHandler;

    public BufferingReadStream(ReadStream<Buffer> stream, Buffer content) {
        this.stream = stream;
        this.content = content;
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.stream.exceptionHandler(handler);
        return this;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        if (handler != null) {
            this.stream.handler(buff -> {
                this.content.appendBuffer(buff);
                handler.handle(buff);
            });
        } else {
            this.stream.handler(null);
        }
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.stream.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.stream.resume();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.stream.fetch(amount);
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        if (endHandler != null) {
            this.stream.endHandler(v -> endHandler.handle(null));
        } else {
            this.stream.endHandler(null);
        }
        return this;
    }
}

