/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import io.vertx.ext.healthchecks.Status;
import java.util.Objects;
import org.infinispan.health.Health;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;

@VertxGen
public interface ClusterHealthCheck {
    public static Handler<Future<Status>> createProcedure(Vertx vertx) {
        return ClusterHealthCheck.createProcedure(vertx, true);
    }

    public static Handler<Future<Status>> createProcedure(Vertx vertx, boolean detailed) {
        Objects.requireNonNull(vertx);
        return future -> {
            VertxInternal vertxInternal = (VertxInternal)vertx;
            InfinispanClusterManager clusterManager = (InfinispanClusterManager)vertxInternal.getClusterManager();
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)clusterManager.getCacheContainer();
            Health health = cacheManager.getHealth();
            HealthStatus healthStatus = health.getClusterHealth().getHealthStatus();
            Status status = new Status().setOk(healthStatus == HealthStatus.HEALTHY);
            if (detailed) {
                status.setData(JsonObject.mapFrom((Object)health));
            }
            future.complete((Object)status);
        };
    }
}

