/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import java.util.Objects;
import org.infinispan.counter.api.SyncStrongCounter;

public class InfinispanCounter
implements Counter {
    private final Vertx vertx;
    private final SyncStrongCounter strongCounter;

    public InfinispanCounter(Vertx vertx, SyncStrongCounter strongCounter) {
        this.vertx = vertx;
        this.strongCounter = strongCounter;
    }

    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.getValue()), false, resultHandler);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(1L, resultHandler);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAndAdd(1L, resultHandler);
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(-1L, resultHandler);
    }

    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.addAndGet(value)), false, resultHandler);
    }

    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.vertx.executeBlocking(future -> future.complete((Object)(this.strongCounter.addAndGet(value) - value)), false, resultHandler);
    }

    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.compareAndSet(expected, value)), false, resultHandler);
    }
}

