/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCSQLRowStream;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StreamQuery
extends AbstractJDBCAction<SQLRowStream> {
    private static final int DEFAULT_ROW_STREAM_FETCH_SIZE = 128;
    private final ContextInternal ctx;
    private final String sql;
    private final JsonArray in;
    private final TaskQueue statementsQueue;

    public StreamQuery(JDBCStatementHelper helper, SQLOptions options, ContextInternal ctx, TaskQueue statementsQueue, String sql, JsonArray in) {
        super(helper, options);
        this.ctx = ctx;
        this.sql = sql;
        this.in = in;
        this.statementsQueue = statementsQueue;
    }

    @Override
    public SQLRowStream execute(Connection conn) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(this.sql);
            this.applyStatementOptions(st);
            this.fillStatement(st, this.in);
            ResultSet rs = null;
            try {
                rs = st.executeQuery();
                int fetchSize = this.options != null && this.options.getFetchSize() > 0 ? this.options.getFetchSize() : 128;
                return new JDBCSQLRowStream(this.ctx, this.statementsQueue, st, rs, this.helper.getDecoder(), fetchSize);
            }
            catch (SQLException e) {
                if (rs != null) {
                    rs.close();
                }
                throw e;
            }
        }
        catch (SQLException e) {
            if (st != null) {
                st.close();
            }
            throw e;
        }
    }
}

