/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.PoolOptions;
import java.security.Principal;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class AgroalCPDataSourceProvider
implements DataSourceProvider {
    public static final String NAME = "Agroal";
    private JsonObject initConfig;

    @Override
    public DataSourceProvider init(JsonObject sqlConfig) {
        this.initConfig = sqlConfig;
        return this;
    }

    @Override
    public JsonObject getInitialConfig() {
        return Optional.ofNullable(this.initConfig).orElseGet(() -> DataSourceProvider.super.getInitialConfig());
    }

    @Override
    public int maximumPoolSize(DataSource dataSource, JsonObject config) throws SQLException {
        if (dataSource instanceof AgroalDataSource) {
            return ((AgroalDataSource)dataSource).getConfiguration().connectionPoolConfiguration().maxSize();
        }
        return -1;
    }

    @Override
    public JsonObject toJson(JDBCConnectOptions connectOptions, PoolOptions poolOptions) {
        JsonObject config = new JsonObject();
        config.put("dataSourceImplementation", (Object)connectOptions.getDataSourceImplementation());
        config.put("connectionValidationTimeout", (Object)connectOptions.getConnectTimeout());
        config.put("minSize", (Object)0);
        config.put("initialSize", (Object)1);
        config.put("maxSize", (Object)poolOptions.getMaxSize());
        config.put("acquisitionTimeout", (Object)connectOptions.getConnectTimeout());
        config.put("connectionReapTimeout", (Object)connectOptions.getIdleTimeout());
        config.put("connectionLeakTimeout", (Object)connectOptions.getIdleTimeout());
        config.put("jdbcUrl", (Object)connectOptions.getJdbcUrl());
        if (connectOptions.getUser() != null) {
            config.put("principal", (Object)connectOptions.getUser());
        }
        if (connectOptions.getPassword() != null) {
            config.put("credential", (Object)connectOptions.getPassword());
        }
        return config;
    }

    @Override
    public DataSource getDataSource(JsonObject cfg) throws SQLException {
        JsonObject config = cfg == null || cfg.isEmpty() ? this.initConfig : cfg;
        AgroalDataSourceConfigurationSupplier dataSourceConfigurationBuilder = new AgroalDataSourceConfigurationSupplier().dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.valueOf((String)config.getString("dataSourceImplementation", "AGROAL"))).metricsEnabled(config.getBoolean("metricsEnabled", Boolean.valueOf(false)).booleanValue()).connectionPoolConfiguration(cp -> cp.validationTimeout(Duration.ofMillis(config.getLong("connectionValidationTimeout", Long.valueOf(30000L)))).minSize(config.getInteger("minSize", Integer.valueOf(0)).intValue()).maxSize(config.getInteger("maxSize", Integer.valueOf(30)).intValue()).initialSize(config.getInteger("initialSize", Integer.valueOf(1)).intValue()).acquisitionTimeout(Duration.ofMillis(config.getInteger("acquisitionTimeout", Integer.valueOf(0)).intValue())).reapTimeout(Duration.ofMillis(config.getLong("connectionReapTimeout", Long.valueOf(0L)))).leakTimeout(Duration.ofMillis(config.getLong("connectionLeakTimeout", Long.valueOf(0L)))).connectionFactoryConfiguration(cf -> {
            if (config.getString("principal") != null) {
                cf = cf.principal((Principal)new NamePrincipal(config.getString("principal")));
            }
            if (config.getString("credential") != null) {
                cf = cf.credential((Object)new SimplePassword(config.getString("credential")));
            }
            return cf.jdbcUrl(config.getString("jdbcUrl"));
        }));
        return AgroalDataSource.from((Supplier)dataSourceConfigurationBuilder, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }

    @Override
    public void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AgroalDataSource) {
            ((AgroalDataSource)dataSource).close();
        }
    }
}

