/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputFormat;
import java.util.Base64;
import java.util.Map;

public class JsonSchemaOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JsonSchemaOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "baseUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBaseUri((String)member.getValue());
                    break;
                }
                case "draft": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDraft(Draft.valueOf((String)member.getValue()));
                    break;
                }
                case "outputFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setOutputFormat(OutputFormat.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(JsonSchemaOptions obj, JsonObject json) {
        JsonSchemaOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JsonSchemaOptions obj, Map<String, Object> json) {
        if (obj.getBaseUri() != null) {
            json.put("baseUri", obj.getBaseUri());
        }
        if (obj.getDraft() != null) {
            json.put("draft", obj.getDraft().name());
        }
        if (obj.getOutputFormat() != null) {
            json.put("outputFormat", obj.getOutputFormat().name());
        }
    }
}

