/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common.dsl;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.common.SchemaURNId;
import io.vertx.json.schema.common.dsl.Keyword;
import io.vertx.json.schema.common.dsl.SchemaType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class SchemaBuilder<T extends SchemaBuilder<?, ?>, K extends Keyword> {
    protected SchemaType type;
    protected final Map<String, Supplier<Object>> keywords;
    protected URI id;
    final T self;

    public SchemaBuilder(SchemaType type) {
        this.type = type;
        this.keywords = new HashMap<String, Supplier<Object>>();
        this.id = new SchemaURNId().toURI();
        this.self = this;
        if (type != null) {
            this.type(type);
        }
    }

    @Fluent
    public T alias(String alias) {
        this.id = new SchemaURNId(alias).toURI();
        return this.self;
    }

    @Fluent
    public T id(JsonPointer id) {
        this.id = id.toURI();
        return this.self;
    }

    @Fluent
    public T with(K keyword) {
        this.keywords.put(((Keyword)keyword).getKeyword(), ((Keyword)keyword).getValueSupplier());
        return this.self;
    }

    @Fluent
    public T with(K ... keywords) {
        for (K k : keywords) {
            this.keywords.put(((Keyword)k).getKeyword(), ((Keyword)k).getValueSupplier());
        }
        return this.self;
    }

    @Fluent
    public T withKeyword(String key, Object value) {
        this.keywords.put(key, () -> value);
        return this.self;
    }

    @Fluent
    public T defaultValue(Object defaultValue) {
        this.keywords.put("default", () -> defaultValue);
        return this.self;
    }

    @Fluent
    public T fromJson(JsonObject object) {
        object.forEach(e -> this.keywords.put((String)e.getKey(), e::getValue));
        return this.self;
    }

    @Fluent
    public T nullable() {
        this.keywords.put("type", () -> new JsonArray().add((Object)this.type.getName()).add((Object)"null"));
        return this.self;
    }

    @Fluent
    public T type(SchemaType type) {
        this.type = type;
        this.keywords.put("type", type::getName);
        return this.self;
    }

    public SchemaType getType() {
        return this.type;
    }

    public JsonObject toJson() {
        JsonObject res = this.keywords.entrySet().stream().collect(JsonObject::new, (jo, e) -> jo.put((String)e.getKey(), ((Supplier)e.getValue()).get()), JsonObject::mergeIn);
        res.put("$id", (Object)this.id.toString());
        return res;
    }

    @Deprecated
    public final Schema build(SchemaParser parser) {
        return parser.parse(this.toJson(), JsonPointer.fromURI((URI)this.id));
    }
}

