/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler;

import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathFinder;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ReflectionUtils;

public class WebsphereTraditionalClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"com.ibm.ws.classloader.CompoundClassLoader", "com.ibm.ws.classloader.ProtectionClassLoader", "com.ibm.ws.bootstrap.ExtClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classloader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) throws Exception {
        String classpath = (String)ReflectionUtils.invokeMethod(classloader, "getClassPath");
        classpathFinder.addClasspathElements(classpath, classloader, log);
    }
}

