/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathElement;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathResource;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.RelativePath;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.matchers.FileMatchProcessorWrapper;
import io.vertx.lang.groovy.fastclasspathscanner.utils.FileUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.InterruptionChecker;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.MultiMapKeyToList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

class ClasspathElementDir
extends ClasspathElement {
    private File dir;

    ClasspathElementDir(RelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles, interruptionChecker);
        if (scanFiles) {
            try {
                this.dir = classpathEltPath.getFile();
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
                }
                this.ioExceptionOnOpen = true;
                return;
            }
            this.fileMatches = new MultiMapKeyToList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    @Override
    public void scanPaths(LogNode log) {
        HashSet<String> scannedCanonicalPaths = new HashSet<String>();
        int[] entryIdx = new int[1];
        this.scanDir(this.dir, this.dir, this.dir.getPath().length() + 1, false, scannedCanonicalPaths, entryIdx, log);
    }

    private ClasspathResource newClasspathResource(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix, final File relativePathFile) {
        return new ClasspathResource(classpathEltFile, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix){
            InputStream inputStream;
            {
                super(classpathEltFile, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix);
                this.inputStream = null;
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementDir.this.ioExceptionOnOpen) {
                    throw new IOException("Parent directory could not be opened");
                }
                try {
                    if (this.inputStream != null) {
                        throw new RuntimeException("Tried to open classpath resource twice");
                    }
                    this.inputStream = new FileInputStream(relativePathFile);
                    this.inputStreamLength = relativePathFile.length();
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.inputStream = null;
                }
            }
        };
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean prevInWhitelistedPath, HashSet<String> scannedCanonicalPaths, int[] entryIdx, LogNode log) {
        String canonicalPath;
        boolean inWhitelistedPath = prevInWhitelistedPath;
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (log != null) {
                log.log("Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        if (this.nestedClasspathRoots != null && this.nestedClasspathRoots.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode dirLog = log == null ? null : log.log(canonicalPath, "Scanning subdirectory path: " + dirRelativePath + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            int n = entryIdx[0];
            entryIdx[0] = n + 1;
            if ((n & 0xFF) == 0 && this.interruptionChecker.checkAndReturn()) {
                return;
            }
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scannedCanonicalPaths, entryIdx, dirLog);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            if (dirLog != null) {
                dirLog.log("Found whitelisted file: " + fileInDirRelativePath);
            }
            this.fileToLastModified.put(fileInDir, fileInDir.lastModified());
            if (FileUtils.isClassfile(fileInDirRelativePath)) {
                this.classfileMatches.add(this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDirRelativePath, fileInDir));
            }
            for (FileMatchProcessorWrapper fileMatchProcessorWrapper : this.scanSpec.getFileMatchProcessorWrappers()) {
                if (!fileMatchProcessorWrapper.filePathMatches(classpathElt, fileInDirRelativePath, dirLog)) continue;
                this.fileMatches.put(fileMatchProcessorWrapper, this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDirRelativePath, fileInDir));
            }
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) {
            this.fileToLastModified.put(dir, dir.lastModified());
        }
        if (log != null) {
            log.addElapsedTime();
        }
    }

    @Override
    public void close() {
    }
}

