/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClassLoaderFinder;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.RelativePath;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.AdditionOrderedSet;
import io.vertx.lang.groovy.fastclasspathscanner.utils.FileUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.JarUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClasspathFinder {
    private final NestedJarHandler nestedJarHandler;
    private static String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final ClassLoader[] envClassLoaderOrder;
    private final List<RelativePath> rawClasspathElements = new ArrayList<RelativePath>();
    private final Set<RelativePath> rawClasspathElementsSet = new HashSet<RelativePath>();

    private boolean addClasspathElement(String pathElement, ClassLoader[] classLoaders, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        if (pathElement.equals("*") || pathElement.endsWith(File.separator + "*")) {
            try {
                File classpathEltParentDir = new RelativePath(currDirPathStr, pathElement.substring(0, pathElement.length() - 1), classLoaders, this.nestedJarHandler).getFile();
                if (!classpathEltParentDir.exists()) {
                    if (log != null) {
                        log.log("Directory does not exist for wildcard classpath element: " + pathElement);
                    }
                    return false;
                }
                if (!classpathEltParentDir.isDirectory()) {
                    if (log != null) {
                        log.log("Wildcard classpath element is not a directory: " + pathElement);
                    }
                    return false;
                }
                LogNode subLog = log == null ? null : log.log("Including wildcard classpath element: " + pathElement);
                for (File fileInDir : classpathEltParentDir.listFiles()) {
                    String name = fileInDir.getName();
                    if (name.equals(".") || name.equals("..")) continue;
                    this.addClasspathElement(fileInDir.getPath(), classLoaders, subLog);
                }
                return true;
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Could not add wildcard classpath element: " + pathElement, e);
                }
                return false;
            }
        }
        RelativePath classpathEltPath = new RelativePath(currDirPathStr, pathElement, classLoaders, this.nestedJarHandler);
        if (this.rawClasspathElementsSet.add(classpathEltPath)) {
            this.rawClasspathElements.add(classpathEltPath);
            if (log != null) {
                log.log("Found classpath element: " + classpathEltPath);
            }
        } else if (log != null) {
            log.log("Ignoring duplicate classpath element: " + classpathEltPath);
        }
        return true;
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElement(pathElement, new ClassLoader[]{classLoader}, log);
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElement(pathStr, new ClassLoader[]{classLoader}, log);
    }

    private boolean addClasspathElements(String pathStr, ClassLoader[] classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathElement(pathElement, classLoaders, log);
        }
        return true;
    }

    private void findClassLoaderHandlerForClassLoaderAndParents(ClassLoader classLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries, AdditionOrderedSet<ClassLoader> foundClassLoaders, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, ScanSpec scanSpec, LogNode log) {
        if (foundClassLoaders.add(classLoader)) {
            boolean foundMatch = false;
            for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                        ClassLoaderHandler classLoaderHandler;
                        block15: {
                            if (!handledClassLoaderName.equals(c.getName())) continue;
                            classLoaderHandler = null;
                            try {
                                classLoaderHandler = classLoaderHandlerRegistryEntry.classLoaderHandlerClass.newInstance();
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                if (log == null) break block15;
                                log.log("Could not instantiate " + classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName(), e);
                            }
                        }
                        if (classLoaderHandler != null) {
                            ClassLoaderHandler.DelegationOrder delegationOrder = classLoaderHandler.getDelegationOrder(classLoader);
                            ClassLoader parent = classLoader.getParent();
                            if (log != null && parent != null) {
                                log.log(classLoader + " delegates to parent " + parent + " with order " + (Object)((Object)delegationOrder));
                            }
                            switch (delegationOrder) {
                                case PARENT_FIRST: {
                                    if (parent != null && !scanSpec.ignoreParentClassLoaders) {
                                        this.findClassLoaderHandlerForClassLoaderAndParents(parent, allClassLoaderHandlerEntries, foundClassLoaders, classLoaderAndHandlerOrderOut, scanSpec, log);
                                    }
                                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                                    break;
                                }
                                case PARENT_LAST: {
                                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                                    if (parent == null || scanSpec.ignoreParentClassLoaders) break;
                                    this.findClassLoaderHandlerForClassLoaderAndParents(parent, allClassLoaderHandlerEntries, foundClassLoaders, classLoaderAndHandlerOrderOut, scanSpec, log);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Unknown delegation order");
                                }
                            }
                            if (log != null) {
                                log.log("ClassLoader " + classLoader + " will be handled by " + classLoaderHandler);
                            }
                        }
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) continue;
                    break;
                }
                if (foundMatch) break;
            }
            if (!foundMatch && log != null) {
                log.log("Could not find a ClassLoaderHandler that can handle " + classLoader + " -- please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
        }
    }

    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        LogNode classpathFinderLog = log == null ? null : log.log("Finding ClassLoaders");
        this.envClassLoaderOrder = ClassLoaderFinder.findEnvClassLoaders(scanSpec, classpathFinderLog);
        this.nestedJarHandler = nestedJarHandler;
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, this.envClassLoaderOrder, overrideLog);
            if (overrideLog != null) {
                classpathFinderLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries;
            String rtJarPath;
            if (!scanSpec.blacklistSystemJars() && (rtJarPath = JarUtils.getRtJarPath()) != null) {
                this.addClasspathElement(rtJarPath, this.envClassLoaderOrder, classpathFinderLog);
            }
            if (scanSpec.extraClassLoaderHandlers.isEmpty()) {
                allClassLoaderHandlerEntries = ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS;
            } else {
                allClassLoaderHandlerEntries = new ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(scanSpec.extraClassLoaderHandlers);
                allClassLoaderHandlerEntries.addAll(ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS);
            }
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    classLoaderHandlerLog.log(classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName());
                }
            }
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            for (ClassLoader envClassLoader : this.envClassLoaderOrder) {
                if (!scanSpec.blacklistSystemJars() || !envClassLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) {
                    this.findClassLoaderHandlerForClassLoaderAndParents(envClassLoader, allClassLoaderHandlerEntries, new AdditionOrderedSet<ClassLoader>(), classLoaderAndHandlerOrder, scanSpec, classpathFinderLog);
                    continue;
                }
                if (classpathFinderLog == null) continue;
                classpathFinderLog.log("Skipping system classloader " + envClassLoader.getClass().getName());
            }
            for (AbstractMap.SimpleEntry simpleEntry : classLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                ClassLoaderHandler classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                LogNode classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Finding classpath elements in ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(classLoader, this, scanSpec, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            if (scanSpec.overrideClassLoaders == null) {
                LogNode sysPropLog = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                this.addClasspathElements(System.getProperty("java.class.path"), this.envClassLoaderOrder, sysPropLog);
            }
        }
    }

    public List<RelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    public ClassLoader[] getClassLoaderOrder() {
        return this.envClassLoaderOrder;
    }
}

