/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cassandra-js/mapping_manager */
var utils = require('vertx-js/util/utils');
var CassandraClient = require('vertx-cassandra-js/cassandra_client');
var Mapper = require('vertx-cassandra-js/mapper');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JMappingManager = Java.type('io.vertx.cassandra.MappingManager');

/**

 @class
*/
var MappingManager = function(j_val) {

  var j_mappingManager = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_mapper = this.mapper;
  /**
   Create a {@link Mapper} that allows conversion of domain classes to and from query results.

   @public
   @param mappedClass {todo} mapped class 
   @return {Mapper}
   */
  this.mapper =  function(mappedClass) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Mapper, j_mappingManager["mapper(java.lang.Class)"](utils.get_jclass(__args[0])), utils.get_jtype(__args[0])) ;
    } else if (typeof __super_mapper != 'undefined') {
      return __super_mapper.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mappingManager;
};

MappingManager._jclass = utils.getJavaClass("io.vertx.cassandra.MappingManager");
MappingManager._jtype = {accept: function(obj) {
    return MappingManager._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MappingManager.prototype, {});
    MappingManager.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MappingManager._create = function(jdel) {var obj = Object.create(MappingManager.prototype, {});
  MappingManager.apply(obj, arguments);
  return obj;
}
/**
 Create a {@link MappingManager} from the given {@link CassandraClient}.

 @memberof module:vertx-cassandra-js/mapping_manager
 @param client {CassandraClient} a Cassandra client instance 
 @return {MappingManager}
 */
MappingManager.create =  function(client) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(MappingManager, JMappingManager["create(io.vertx.cassandra.CassandraClient)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MappingManager;