/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mysql-client-js/my_sql_pool */
var utils = require('vertx-js/util/utils');
var Query = require('vertx-sql-client-js/query');
var Row = require('vertx-sql-client-js/row');
var Vertx = require('vertx-js/vertx');
var Pool = require('vertx-sql-client-js/pool');
var RowSet = require('vertx-sql-client-js/row_set');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JMySQLPool = Java.type('io.vertx.mysqlclient.MySQLPool');
var MySQLConnectOptions = Java.type('io.vertx.mysqlclient.MySQLConnectOptions');
var PoolOptions = Java.type('io.vertx.sqlclient.PoolOptions');

/**
 A pool of MySQL connections.

 @class
*/
var MySQLPool = function(j_val) {

  var j_mySQLPool = j_val;
  var that = this;
  Pool.call(this, j_val);

  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mySQLPool;
};

MySQLPool._jclass = utils.getJavaClass("io.vertx.mysqlclient.MySQLPool");
MySQLPool._jtype = {accept: function(obj) {
    return MySQLPool._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MySQLPool.prototype, {});
    MySQLPool.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MySQLPool._create = function(jdel) {var obj = Object.create(MySQLPool.prototype, {});
  MySQLPool.apply(obj, arguments);
  return obj;
}
/**
 Like {@link MySQLPool#pool} with a specific  instance.

 @memberof module:vertx-mysql-client-js/my_sql_pool
 @param vertx {Vertx} 
 @param connectOptions {Object} 
 @param poolOptions {Object} 
 @return {MySQLPool}
 */
MySQLPool.pool =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(java.lang.String)"](__args[0])) ;
  } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(java.lang.String,io.vertx.sqlclient.PoolOptions)"](__args[0], __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(io.vertx.core.Vertx,java.lang.String,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1], __args[2]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  } else if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(io.vertx.mysqlclient.MySQLConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]  != null ? new MySQLConnectOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(MySQLPool, JMySQLPool["pool(io.vertx.core.Vertx,io.vertx.mysqlclient.MySQLConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1]  != null ? new MySQLConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, __args[2]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MySQLPool;