/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/prepared_query */
var utils = require('vertx-js/util/utils');
var Query = require('vertx-sql-client-js/query');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPreparedQuery = Java.type('io.vertx.sqlclient.PreparedQuery');

/**
 A query for a prepared statement allowing parameterized execution of the query, this query will use
 a prepared statement.

 @class
*/
var PreparedQuery = function(j_val, j_arg_0) {

  var j_preparedQuery = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;Query.call(this, j_val, j_T);

  var __super_execute = this.execute;
  var __super_execute = this.execute;
  var __super_executeBatch = this.executeBatch;
  var __super_mapping = this.mapping;
  /**
   Execute the query.

   @public
   @param tuple {Tuple} 
   @param handler {function} the handler receiving the response 
   */
  this.execute =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_preparedQuery["execute(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](j_T.wrap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
      j_preparedQuery["execute(io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[1](j_T.wrap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_execute != 'undefined') {
      return __super_execute.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Execute the query with a batch of tuples.

   @public
   @param batch {Array.<Tuple>} the batch of tuples 
   @param handler {function} the handler receiving the response 
   */
  this.executeBatch =  function(batch, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_preparedQuery["executeBatch(java.util.List,io.vertx.core.Handler)"](utils.convParamListVertxGen(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](j_T.wrap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_executeBatch != 'undefined') {
      return __super_executeBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Use the specified <code>mapper</code> for mapping {@link Row} to <code><U></code>.

   @public
   @param mapper {function} 
   @return {PreparedQuery}
   */
  this.mapping =  function(mapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(PreparedQuery, j_preparedQuery["mapping(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(Row, jVal));
        return utils.convParamTypeUnknown(jRet);
      }), RowSet._jtype) ;
    } else if (typeof __super_mapping != 'undefined') {
      return __super_mapping.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_preparedQuery;
};

PreparedQuery._jclass = utils.getJavaClass("io.vertx.sqlclient.PreparedQuery");
PreparedQuery._jtype = {accept: function(obj) {
    return PreparedQuery._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PreparedQuery.prototype, {});
    PreparedQuery.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PreparedQuery._create = function(jdel) {var obj = Object.create(PreparedQuery.prototype, {});
  PreparedQuery.apply(obj, arguments);
  return obj;
}
module.exports = PreparedQuery;