/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/sql_client */
var utils = require('vertx-js/util/utils');
var Query = require('vertx-sql-client-js/query');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JSqlClient = Java.type('io.vertx.sqlclient.SqlClient');

/**
 Defines the client operations with a database server.

 @class
*/
var SqlClient = function(j_val) {

  var j_sqlClient = j_val;
  var that = this;

  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_close = this.close;
  /**
   Create a query, the {@link Query#execute} method must be called to execute the query.

   @public
   @param sql {string} 
   @return {Query} the query
   */
  this.query =  function(sql) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Query, j_sqlClient["query(java.lang.String)"](__args[0]), RowSet._jtype) ;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a prepared query, one of the {@link Query#execute} or {@link PreparedQuery#executeBatch}
   methods must be called to execute the query.

   @public
   @param sql {string} 
   @return {PreparedQuery} the prepared query
   */
  this.preparedQuery =  function(sql) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(PreparedQuery, j_sqlClient["preparedQuery(java.lang.String)"](__args[0]), RowSet._jtype) ;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the client and release the associated resources.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sqlClient["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sqlClient;
};

SqlClient._jclass = utils.getJavaClass("io.vertx.sqlclient.SqlClient");
SqlClient._jtype = {accept: function(obj) {
    return SqlClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SqlClient.prototype, {});
    SqlClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SqlClient._create = function(jdel) {var obj = Object.create(SqlClient.prototype, {});
  SqlClient.apply(obj, arguments);
  return obj;
}
module.exports = SqlClient;