/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-common-js/form_data_part */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JFormDataPart = Java.type('io.vertx.ext.web.multipart.FormDataPart');

/**

 @class
*/
var FormDataPart = function(j_val) {

  var j_formDataPart = j_val;
  var that = this;

  var __super_name = this.name;
  var __super_isAttribute = this.isAttribute;
  var __super_isFileUpload = this.isFileUpload;
  var __super_value = this.value;
  var __super_filename = this.filename;
  var __super_pathname = this.pathname;
  var __super_mediaType = this.mediaType;
  var __super_isText = this.isText;
  /**

   @public

   @return {string} the name
   */
  this.name =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedname == null) {
        that.cachedname = j_formDataPart["name()"]();
      }
      return that.cachedname;
    } else if (typeof __super_name != 'undefined') {
      return __super_name.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} <code>true</code> when this part is an attribute
   */
  this.isAttribute =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedisAttribute == null) {
        that.cachedisAttribute = j_formDataPart["isAttribute()"]();
      }
      return that.cachedisAttribute;
    } else if (typeof __super_isAttribute != 'undefined') {
      return __super_isAttribute.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} <code>true</code> when this part is a file upload
   */
  this.isFileUpload =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedisFileUpload == null) {
        that.cachedisFileUpload = j_formDataPart["isFileUpload()"]();
      }
      return that.cachedisFileUpload;
    } else if (typeof __super_isFileUpload != 'undefined') {
      return __super_isFileUpload.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the value when the part for a form attribute otherwise <code>null</code>
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedvalue == null) {
        that.cachedvalue = j_formDataPart["value()"]();
      }
      return that.cachedvalue;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the filename when this part is a file upload otherwise <code>null</code>
   */
  this.filename =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedfilename == null) {
        that.cachedfilename = j_formDataPart["filename()"]();
      }
      return that.cachedfilename;
    } else if (typeof __super_filename != 'undefined') {
      return __super_filename.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the pathname when this part is a file upload otherwise <code>null</code>
   */
  this.pathname =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedpathname == null) {
        that.cachedpathname = j_formDataPart["pathname()"]();
      }
      return that.cachedpathname;
    } else if (typeof __super_pathname != 'undefined') {
      return __super_pathname.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the media type when this part is a file upload otherwise <code>null</code>
   */
  this.mediaType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedmediaType == null) {
        that.cachedmediaType = j_formDataPart["mediaType()"]();
      }
      return that.cachedmediaType;
    } else if (typeof __super_mediaType != 'undefined') {
      return __super_mediaType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the file upload is text or binary when this part is a file upload otherwise <code>null</code>
   */
  this.isText =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedisText == null) {
        that.cachedisText = j_formDataPart["isText()"]();
      }
      return that.cachedisText;
    } else if (typeof __super_isText != 'undefined') {
      return __super_isText.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_formDataPart;
};

FormDataPart._jclass = utils.getJavaClass("io.vertx.ext.web.multipart.FormDataPart");
FormDataPart._jtype = {accept: function(obj) {
    return FormDataPart._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(FormDataPart.prototype, {});
    FormDataPart.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
FormDataPart._create = function(jdel) {var obj = Object.create(FormDataPart.prototype, {});
  FormDataPart.apply(obj, arguments);
  return obj;
}
module.exports = FormDataPart;