/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/cookie */
var utils = require('vertx-js/util/utils');
var Cookie = require('vertx-js/cookie');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCookie = Java.type('io.vertx.ext.web.Cookie');

/**
 Represents an HTTP Cookie.
 <p>
 All cookies must have a name and a value and can optionally have other fields set such as path, domain, etc.
 <p>
 (Derived from io.netty.handler.codec.http.Cookie)

 @class
*/
var Cookie = function(j_val) {

  var j_cookie = j_val;
  var that = this;
  Cookie.call(this, j_val);

  var __super_cookie = this.cookie;
  var __super_setValue = this.setValue;
  var __super_setDomain = this.setDomain;
  var __super_setPath = this.setPath;
  var __super_setMaxAge = this.setMaxAge;
  var __super_setSecure = this.setSecure;
  var __super_setHttpOnly = this.setHttpOnly;
  var __super_isChanged = this.isChanged;
  var __super_setChanged = this.setChanged;
  var __super_isFromUserAgent = this.isFromUserAgent;
  /**

   @public
   @param value {string} 
   @return {Cookie}
   */
  this.setValue =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_cookie["setValue(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setValue != 'undefined') {
      return __super_setValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param domain {string} 
   @return {Cookie}
   */
  this.setDomain =  function(domain) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'string' || __args[0] == null)) {
      j_cookie["setDomain(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setDomain != 'undefined') {
      return __super_setDomain.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param path {string} 
   @return {Cookie}
   */
  this.setPath =  function(path) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'string' || __args[0] == null)) {
      j_cookie["setPath(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setPath != 'undefined') {
      return __super_setPath.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param maxAge {number} 
   @return {Cookie}
   */
  this.setMaxAge =  function(maxAge) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_cookie["setMaxAge(long)"](__args[0]) ;
      return that;
    } else if (typeof __super_setMaxAge != 'undefined') {
      return __super_setMaxAge.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param secure {boolean} 
   @return {Cookie}
   */
  this.setSecure =  function(secure) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_cookie["setSecure(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_setSecure != 'undefined') {
      return __super_setSecure.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param httpOnly {boolean} 
   @return {Cookie}
   */
  this.setHttpOnly =  function(httpOnly) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_cookie["setHttpOnly(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_setHttpOnly != 'undefined') {
      return __super_setHttpOnly.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Has the cookie been changed? Changed cookieMap will be saved out in the response and sent to the browser.

   @public

   @return {boolean} true if changed
   */
  this.isChanged =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_cookie["isChanged()"]() ;
    } else if (typeof __super_isChanged != 'undefined') {
      return __super_isChanged.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the cookie as being changed. Changed will be true for a cookie just created, false by default if just
   read from the request

   @public
   @param changed {boolean} true if changed 
   */
  this.setChanged =  function(changed) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_cookie["setChanged(boolean)"](__args[0]);
    } else if (typeof __super_setChanged != 'undefined') {
      return __super_setChanged.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Has this Cookie been sent from the User Agent (the browser)? or was created during the executing on the request.

   @public

   @return {boolean} true if the cookie comes from the User Agent.
   */
  this.isFromUserAgent =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_cookie["isFromUserAgent()"]() ;
    } else if (typeof __super_isFromUserAgent != 'undefined') {
      return __super_isFromUserAgent.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_cookie;
};

Cookie._jclass = utils.getJavaClass("io.vertx.ext.web.Cookie");
Cookie._jtype = {accept: function(obj) {
    return Cookie._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Cookie.prototype, {});
    Cookie.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Cookie._create = function(jdel) {var obj = Object.create(Cookie.prototype, {});
  Cookie.apply(obj, arguments);
  return obj;
}
/**
 Create a new cookie

 @memberof module:vertx-web-js/cookie
 @param name {string} the name of the cookie 
 @param value {string} the cookie value 
 @return {Cookie} the cookie
 */
Cookie.cookie =  function(name, value) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(Cookie, JCookie["cookie(java.lang.String,java.lang.String)"](__args[0], __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Cookie;