require 'vertx/promise'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.bridge.BaseBridgeEvent
module VertxBridgeCommon
  #  Represents an event that occurs on the event bus bridge.
  #  <p>
  #  Please consult the documentation for a full explanation.
  class BaseBridgeEvent < ::Vertx::Promise
    # @private
    # @param j_del [::VertxBridgeCommon::BaseBridgeEvent] the java delegate
    def initialize(j_del)
      super(j_del, nil)
      @j_del = j_del
    end
    # @private
    # @return [::VertxBridgeCommon::BaseBridgeEvent] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BaseBridgeEvent
    end
    def @@j_api_type.wrap(obj)
      BaseBridgeEvent.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtBridge::BaseBridgeEvent.java_class
    end
    #  Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
    #  <p/>
    #  Any handler set on the associated promise will be called.
    # @param [true,false] result the result
    # @return [void]
    def complete(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:complete, []).call()
      elsif (result.class == TrueClass || result.class == FalseClass) && !block_given?
        return @j_del.java_method(:complete, [Java::JavaLang::Boolean.java_class]).call(result)
      end
      raise ArgumentError, "Invalid arguments when calling complete(#{result})"
    end
    #  Calls {::Vertx::Promise#fail} with the <code>message</code>.
    # @overload fail(cause)
    #   @param [Exception] cause the failure cause
    # @overload fail(message)
    #   @param [String] message the failure message
    # @return [void]
    def fail(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:fail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:fail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling fail(#{param_1})"
    end
    #  Like {::Vertx::Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
    #  an IllegalStateException, it returns <code>true</code> otherwise.
    # @param [true,false] result the result
    # @return [true,false] <code>false</code> when the future is already completed
    def try_complete?(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:tryComplete, []).call()
      elsif (result.class == TrueClass || result.class == FalseClass) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::JavaLang::Boolean.java_class]).call(result)
      end
      raise ArgumentError, "Invalid arguments when calling try_complete?(#{result})"
    end
    #  Calls {::Vertx::Promise#fail} with the <code>message</code>.
    # @overload tryFail(cause)
    #   @param [Exception] cause the failure cause
    # @overload tryFail(message)
    #   @param [String] message the failure message
    # @return [true,false] false when the future is already completed
    def try_fail?(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:tryFail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:tryFail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling try_fail?(#{param_1})"
    end
    # @return [::Vertx::Future] the  associated with this promise, it can be used to be aware of the promise completion
    def future
      if !block_given?
        if @cached_future != nil
          return @cached_future
        end
        return @cached_future = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:future, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling future()"
    end
    # @return [:SOCKET_CREATED,:SOCKET_CLOSED,:SOCKET_IDLE,:SOCKET_PING,:SEND,:PUBLISH,:RECEIVE,:REGISTER,:UNREGISTER] the type of the event
    def type
      if !block_given?
        if @cached_type != nil
          return @cached_type
        end
        return @cached_type = @j_del.java_method(:type, []).call().name.intern
      end
      raise ArgumentError, "Invalid arguments when calling type()"
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved. If the returned message is modified, {::VertxBridgeCommon::BaseBridgeEvent#set_raw_message} should be called with the
    #  new message.
    # @return [Hash{String => Object}] the raw JSON message for the event
    def get_raw_message
      if !block_given?
        return @j_del.java_method(:getRawMessage, []).call() != nil ? JSON.parse(@j_del.java_method(:getRawMessage, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_raw_message()"
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved.
    # @param [Hash{String => Object}] message the raw message
    # @return [self]
    def set_raw_message(message=nil)
      if message.class == Hash && !block_given?
        @j_del.java_method(:setRawMessage, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(message))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_raw_message(#{message})"
    end
  end
end
