require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.admin.KafkaAdminClient
module VertxKafkaClient
  #  Vert.x Kafka Admin client implementation
  class KafkaAdminClient
    # @private
    # @param j_del [::VertxKafkaClient::KafkaAdminClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxKafkaClient::KafkaAdminClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KafkaAdminClient
    end
    def @@j_api_type.wrap(obj)
      KafkaAdminClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxKafkaAdmin::KafkaAdminClient.java_class
    end
    #  Create a new KafkaAdminClient instance
    # @param [::Vertx::Vertx] vertx Vert.x instance to use
    # @param [Hash{String => String}] config Kafka admin client configuration
    # @return [::VertxKafkaClient::KafkaAdminClient] an instance of the KafkaAdminClient
    def self.create(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaAdmin::KafkaAdminClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class]).call(vertx.j_del,Hash[config.map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaAdminClient)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{config})"
    end
    #  List the topics available in the cluster with the default options.
    # @yield handler called on operation completed with the topics set
    # @return [void]
    def list_topics
      if block_given?
        return @j_del.java_method(:listTopics, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling list_topics()"
    end
    #  Creates a batch of new Kafka topics
    # @param [Array<Hash>] topics topics to create
    # @yield handler called on operation completed
    # @return [void]
    def create_topics(topics=nil)
      if topics.class == Array && block_given?
        return @j_del.java_method(:createTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(topics.map { |element| Java::IoVertxKafkaAdmin::NewTopic.new(::Vertx::Util::Utils.to_json_object(element)) },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling create_topics(#{topics})"
    end
    #  Deletes a batch of Kafka topics
    # @param [Array<String>] topicNames the names of the topics to delete
    # @yield handler called on operation completed
    # @return [void]
    def delete_topics(topicNames=nil)
      if topicNames.class == Array && block_given?
        return @j_del.java_method(:deleteTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(topicNames.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling delete_topics(#{topicNames})"
    end
    #  Get the the consumer groups available in the cluster with the default options
    # @yield handler called on operation completed with the consumer groups ids
    # @return [void]
    def list_consumer_groups
      if block_given?
        return @j_del.java_method(:listConsumerGroups, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling list_consumer_groups()"
    end
    #  Close the admin client
    # @param [Fixnum] timeout timeout to wait for closing
    # @yield handler called on operation completed
    # @return [void]
    def close(timeout=nil)
      if !block_given? && timeout == nil
        return @j_del.java_method(:close, []).call()
      elsif block_given? && timeout == nil
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      elsif timeout.class == Fixnum && block_given?
        return @j_del.java_method(:close, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(timeout,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close(#{timeout})"
    end
  end
end
