require 'vertx/pipe'
require 'vertx-redis/response'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx-redis/request'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.RedisConnection
module VertxRedis
  #  A simple Redis client.
  class RedisConnection
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxRedis::RedisConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::RedisConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RedisConnection
    end
    def @@j_api_type.wrap(obj)
      RedisConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::RedisConnection.java_class
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxRedis::Response.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    #  
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxRedis::Response)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    #  
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    #  
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    #  
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    #  
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Send the given command to the redis server or cluster.
    # @param [::VertxRedis::Request] command the command to send
    # @yield the asynchronous result handler.
    # @return [self]
    def send(command=nil)
      if command.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(command.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling send(#{command})"
    end
    #  Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
    #  client users.
    # @param [Array<::VertxRedis::Request>] commands list of command to send
    # @yield the asynchronous result handler.
    # @return [self]
    def batch(commands=nil)
      if commands.class == Array && block_given?
        @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(commands.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling batch(#{commands})"
    end
    #  Closes the connection or returns to the pool.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Flag to notify if the pending message queue (commands in transit) is full.
    # 
    #  When the pending message queue is full and a new send command is issued it will result in a exception to be thrown.
    #  Checking this flag before sending can allow the application to wait before sending the next message.
    # @return [true,false] true is queue is full.
    def pending_queue_full?
      if !block_given?
        return @j_del.java_method(:pendingQueueFull, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling pending_queue_full?()"
    end
  end
end
