require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.Script
module VertxRedis
  #  This factory is deprecated use {::VertxRedis::Redis} instead,
  #  or for a typed API {::VertxRedis::RedisAPI}.
  class Script
    # @private
    # @param j_del [::VertxRedis::Script] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Script] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Script
    end
    def @@j_api_type.wrap(obj)
      Script.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedis::Script.java_class
    end
    # @param [String] script 
    # @param [String] sha1 
    # @return [::VertxRedis::Script]
    def self.create(script=nil,sha1=nil)
      if script.class == String && !block_given? && sha1 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedis::Script.java_method(:create, [Java::java.lang.String.java_class]).call(script),::VertxRedis::Script)
      elsif script.class == String && sha1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedis::Script.java_method(:create, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(script,sha1),::VertxRedis::Script)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{script},#{sha1})"
    end
    # @return [String]
    def get_script
      if !block_given?
        return @j_del.java_method(:getScript, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_script()"
    end
    # @return [String]
    def get_sha1
      if !block_given?
        return @j_del.java_method(:getSha1, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_sha1()"
    end
  end
end
