require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/sql_connection'
require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/prepared_query'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Pool
module VertxSqlClient
  #  A pool of SQL connections.
  class Pool < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::Pool] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Pool] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Pool
    end
    def @@j_api_type.wrap(obj)
      Pool.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Pool.java_class
    end
    #  Get a connection from the pool.
    # @yield the handler that will get the connection result
    # @return [void]
    def get_connection
      if block_given?
        return @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::SqlConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    #  
    # 
    #  A connection is borrowed from the connection pool when the query is executed and then immediately returned
    #  to the pool after it completes.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query]
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  
    # 
    #  A connection is borrowed from the connection pool when the query is executed and then immediately returned
    #  to the pool after it completes.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery]
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
    #  to the pool when the transaction ends.
    # @yield 
    # @return [void]
    def begin
      if block_given?
        return @j_del.java_method(:begin, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::Transaction) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    #  Close the pool and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
