require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/prepared_statement'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.SqlConnection
module VertxSqlClient
  #  A connection to database server.
  class SqlConnection < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::SqlConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::SqlConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SqlConnection
    end
    def @@j_api_type.wrap(obj)
      SqlConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::SqlConnection.java_class
    end
    #  Create a query, the {::VertxSqlClient::Query#execute} method must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query] the query
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Create a prepared query, one of the {::VertxSqlClient::Query#execute} or {::VertxSqlClient::PreparedQuery#execute_batch}
    #  methods must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery] the prepared query
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Create a prepared query.
    # @param [String] sql the sql
    # @yield the handler notified with the prepared query asynchronously
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedStatement) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    #  Set an handler called with connection errors.
    # @yield the handler
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Set an handler called when the connection is closed.
    # @yield the handler
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    #  Begin a transaction and returns a {::VertxSqlClient::Transaction} for controlling and tracking
    #  this transaction.
    #  <p/>
    #  When the connection is explicitely closed, any inflight transaction is rollbacked.
    # @return [::VertxSqlClient::Transaction] the transaction instance
    def begin
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:begin, []).call(),::VertxSqlClient::Transaction)
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    # @return [true,false] whether the connection uses SSL
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSSL, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    #  Close the current connection after all the pending commands have been processed.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
