/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptionsConverter;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class AggregateOptions {
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final long DEFAULT_MAX_TIME = 0L;
    public static final long DEFAULT_MAX_AWAIT_TIME = 1000L;
    private int batchSize;
    private long maxTime;
    private long maxAwaitTime;
    private Boolean allowDiskUse;

    public AggregateOptions() {
        this.batchSize = 20;
        this.maxTime = 0L;
        this.maxAwaitTime = 1000L;
    }

    public AggregateOptions(AggregateOptions options) {
        this.batchSize = options.batchSize;
        this.maxTime = options.maxTime;
        this.maxAwaitTime = options.maxAwaitTime;
        this.allowDiskUse = options.allowDiskUse;
    }

    public AggregateOptions(JsonObject options) {
        this();
        AggregateOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AggregateOptionsConverter.toJson(this, json);
        return json;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public AggregateOptions setMaxTime(long maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateOptions setAllowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public AggregateOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxAwaitTime() {
        return this.maxAwaitTime;
    }

    public AggregateOptions setMaxAwaitTime(long maxAwaitTime) {
        this.maxAwaitTime = maxAwaitTime;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateOptions that = (AggregateOptions)o;
        return this.batchSize == that.batchSize && this.maxTime == that.maxTime && this.maxAwaitTime == that.maxAwaitTime && this.allowDiskUse == that.allowDiskUse;
    }

    public int hashCode() {
        return Objects.hash(this.batchSize, this.maxTime, this.maxAwaitTime, this.allowDiskUse);
    }
}

