/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@DataObject
public class MongoClientBulkWriteResult {
    public static final String INSERTED_COUNT = "insertedCount";
    public static final String MATCHED_COUNT = "matchedCount";
    public static final String MODIFIED_COUNT = "modifiedCount";
    public static final String DELETED_COUNT = "deletedCount";
    public static final String UPSERTS = "upserts";
    public static final String ID = "_id";
    public static final String INDEX = "index";
    public static final long DEFAULT_INSERTED_COUNT = 0L;
    public static final long DEFAULT_MATCHED_COUNT = 0L;
    public static final long DEFAULT_DELETED_COUNT = 0L;
    public static final long DEFAULT_MODIFIED_COUNT = 0L;
    private long insertedCount;
    private long matchedCount;
    private long deletedCount;
    private long modifiedCount;
    private List<JsonObject> upserts;

    public MongoClientBulkWriteResult() {
        this.insertedCount = 0L;
        this.matchedCount = 0L;
        this.deletedCount = 0L;
        this.modifiedCount = 0L;
    }

    public MongoClientBulkWriteResult(long insertedCount, long matchedCount, long deletedCount, long modifiedCount, List<JsonObject> upserts) {
        this.insertedCount = insertedCount;
        this.matchedCount = matchedCount;
        this.deletedCount = deletedCount;
        this.modifiedCount = modifiedCount;
        this.upserts = upserts;
    }

    public MongoClientBulkWriteResult(MongoClientBulkWriteResult other) {
        this.insertedCount = other.insertedCount;
        this.matchedCount = other.matchedCount;
        this.deletedCount = other.deletedCount;
        this.modifiedCount = other.modifiedCount;
        this.upserts = other.upserts != null ? other.upserts.stream().map(JsonObject::copy).collect(Collectors.toList()) : null;
    }

    public MongoClientBulkWriteResult(JsonObject mongoClientBulkWriteResultJson) {
        this.insertedCount = mongoClientBulkWriteResultJson.getLong(INSERTED_COUNT, Long.valueOf(0L));
        this.matchedCount = mongoClientBulkWriteResultJson.getLong(MATCHED_COUNT, Long.valueOf(0L));
        this.deletedCount = mongoClientBulkWriteResultJson.getLong(DELETED_COUNT, Long.valueOf(0L));
        this.modifiedCount = mongoClientBulkWriteResultJson.getLong(MODIFIED_COUNT, Long.valueOf(0L));
        JsonArray upsertArray = mongoClientBulkWriteResultJson.getJsonArray(UPSERTS);
        if (upsertArray != null) {
            this.upserts = upsertArray.stream().filter(object -> object instanceof JsonObject).map(object -> (JsonObject)object).collect(Collectors.toList());
        }
    }

    public JsonObject toJson() {
        JsonObject mongoClientBulkWriteResultJson = new JsonObject();
        if (this.insertedCount != 0L) {
            mongoClientBulkWriteResultJson.put(INSERTED_COUNT, Long.valueOf(this.insertedCount));
        }
        if (this.matchedCount != 0L) {
            mongoClientBulkWriteResultJson.put(MATCHED_COUNT, Long.valueOf(this.matchedCount));
        }
        if (this.deletedCount != 0L) {
            mongoClientBulkWriteResultJson.put(DELETED_COUNT, Long.valueOf(this.deletedCount));
        }
        if (this.modifiedCount != 0L) {
            mongoClientBulkWriteResultJson.put(MODIFIED_COUNT, Long.valueOf(this.modifiedCount));
        }
        if (this.upserts != null) {
            mongoClientBulkWriteResultJson.put(UPSERTS, new JsonArray(this.upserts));
        }
        return mongoClientBulkWriteResultJson;
    }

    public long getInsertedCount() {
        return this.insertedCount;
    }

    public long getMatchedCount() {
        return this.matchedCount;
    }

    public long getDeletedCount() {
        return this.deletedCount;
    }

    public long getModifiedCount() {
        return this.modifiedCount;
    }

    public List<JsonObject> getUpserts() {
        if (this.upserts != null) {
            return Collections.unmodifiableList(this.upserts);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.deletedCount ^ this.deletedCount >>> 32);
        result = 31 * result + (int)(this.insertedCount ^ this.insertedCount >>> 32);
        result = 31 * result + (int)(this.matchedCount ^ this.matchedCount >>> 32);
        result = 31 * result + (int)(this.modifiedCount ^ this.modifiedCount >>> 32);
        result = 31 * result + (this.upserts == null ? 0 : this.upserts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MongoClientBulkWriteResult other = (MongoClientBulkWriteResult)obj;
        if (this.deletedCount != other.deletedCount) {
            return false;
        }
        if (this.insertedCount != other.insertedCount) {
            return false;
        }
        if (this.matchedCount != other.matchedCount) {
            return false;
        }
        if (this.modifiedCount != other.modifiedCount) {
            return false;
        }
        return !(this.upserts == null ? other.upserts != null : !this.upserts.equals(other.upserts));
    }
}

