/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;

@VertxGen
public interface MySQLPool
extends Pool {
    public static MySQLPool pool(String connectionUri) {
        return MySQLPool.pool(connectionUri, new PoolOptions());
    }

    public static MySQLPool pool(String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.pool(MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static MySQLPool pool(MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use MySQLPool#pool(Vertx, MySQLConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return new MySQLPoolImpl(vertx.getOrCreateContext(), true, connectOptions, poolOptions);
    }

    public static MySQLPool pool(Vertx vertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        return new MySQLPoolImpl(vertx.getOrCreateContext(), false, connectOptions, poolOptions);
    }
}

