/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.impl.MySQLRowDesc;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MySQLRowImpl
extends ArrayTuple
implements Row {
    private final MySQLRowDesc rowDesc;

    public MySQLRowImpl(MySQLRowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJsonObject(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJsonArray(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int idx) {
        throw new UnsupportedOperationException("MySQL Array data type is not supported");
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.rowDesc.columnNames().indexOf(name);
    }

    public Numeric getNumeric(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public Temporal getTemporal(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalTime getLocalTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalTime(pos);
    }

    public OffsetTime getOffsetTime(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, OffsetTime.class));
    }

    public OffsetDateTime getOffsetDateTime(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, OffsetDateTime.class));
    }

    public UUID getUUID(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, UUID.class));
    }

    public Integer[] getIntegerArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Integer[].class));
    }

    public Boolean[] getBooleanArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Boolean[].class));
    }

    public Short[] getShortArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Short[].class));
    }

    public Long[] getLongArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Long[].class));
    }

    public Float[] getFloatArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Float[].class));
    }

    public Double[] getDoubleArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Double[].class));
    }

    public String[] getStringArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, String[].class));
    }

    public LocalDate[] getLocalDateArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, LocalDate[].class));
    }

    public LocalTime[] getLocalTimeArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, LocalTime[].class));
    }

    public OffsetTime[] getOffsetTimeArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, OffsetTime[].class));
    }

    public LocalDateTime[] getLocalDateTimeArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, LocalDateTime[].class));
    }

    public OffsetDateTime[] getOffsetDateTimeArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, OffsetDateTime[].class));
    }

    public Buffer[] getBufferArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, Buffer[].class));
    }

    public UUID[] getUUIDArray(String name) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(name), name, UUID[].class));
    }

    public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue() != 0;
        }
        return null;
    }

    public Numeric getNumeric(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse((String)val.toString());
        }
        return null;
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private JsonObject getJsonObject(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        return null;
    }

    private JsonArray getJsonArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        return null;
    }

    public LocalTime getLocalTime(int pos) {
        ColumnDefinition columnDefinition = this.rowDesc.columnDefinitions()[pos];
        Object val = this.getValue(pos);
        if (columnDefinition.getType() == DataType.TIME && val instanceof Duration) {
            Duration duration = (Duration)val;
            return LocalTime.ofNanoOfDay(duration.toNanos());
        }
        return super.getLocalTime(pos);
    }

    private <T> String buildIllegalAccessMessage(Object value, String columnName, Class<T> clazz) {
        return String.format("Can not retrieve row value[%s] as class[%s], columnName=[%s]", value.toString(), clazz.getName(), columnName);
    }
}

