/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.datatype;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.codec.CommonCodec;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class DataTypeCodec {
    public static final Object REFUSED_SENTINEL = new Object();
    private static final DateTimeFormatter DATETIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeText(DataType dataType, int collationId, int columnDefinitionFlags, ByteBuf buffer) {
        int length = (int)BufferUtils.readLengthEncodedInteger(buffer);
        int index = buffer.readerIndex();
        try {
            switch (dataType) {
                case INT1: {
                    if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                        Short s = DataTypeCodec.textDecodeInt2(buffer, index, length);
                        return s;
                    }
                    Byte by = DataTypeCodec.textDecodeInt1(buffer, index, length);
                    return by;
                }
                case YEAR: {
                    Short s = DataTypeCodec.textDecodeInt2(buffer, index, length);
                    return s;
                }
                case INT2: {
                    if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                        Integer n = DataTypeCodec.textDecodeInt4(buffer, index, length);
                        return n;
                    }
                    Short s = DataTypeCodec.textDecodeInt2(buffer, index, length);
                    return s;
                }
                case INT3: {
                    Integer n = DataTypeCodec.textDecodeInt4(buffer, index, length);
                    return n;
                }
                case INT4: {
                    if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                        Long l = DataTypeCodec.textDecodeInt8(buffer, index, length);
                        return l;
                    }
                    Integer n = DataTypeCodec.textDecodeInt4(buffer, index, length);
                    return n;
                }
                case INT8: {
                    if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                        Number number = DataTypeCodec.textDecodeNUMERIC(collationId, buffer, index, length);
                        return number;
                    }
                    Long l = DataTypeCodec.textDecodeInt8(buffer, index, length);
                    return l;
                }
                case FLOAT: {
                    Float f = DataTypeCodec.textDecodeFloat(collationId, buffer, index, length);
                    return f;
                }
                case DOUBLE: {
                    Double d = DataTypeCodec.textDecodeDouble(collationId, buffer, index, length);
                    return d;
                }
                case BIT: {
                    Long l = DataTypeCodec.textDecodeBit(buffer, index, length);
                    return l;
                }
                case NUMERIC: {
                    Number number = DataTypeCodec.textDecodeNUMERIC(collationId, buffer, index, length);
                    return number;
                }
                case DATE: {
                    LocalDate localDate = DataTypeCodec.textDecodeDate(collationId, buffer, index, length);
                    return localDate;
                }
                case TIME: {
                    Duration duration = DataTypeCodec.textDecodeTime(collationId, buffer, index, length);
                    return duration;
                }
                case DATETIME: 
                case TIMESTAMP: {
                    LocalDateTime localDateTime = DataTypeCodec.textDecodeDateTime(collationId, buffer, index, length);
                    return localDateTime;
                }
                case JSON: {
                    Object object = DataTypeCodec.textDecodeJson(collationId, buffer, index, length);
                    return object;
                }
            }
            Object object = DataTypeCodec.textDecodeBlobOrText(collationId, columnDefinitionFlags, buffer, index, length);
            return object;
        }
        finally {
            buffer.readerIndex(index + length);
        }
    }

    public static void encodeBinary(DataType dataType, Object value, Charset charset, ByteBuf buffer) {
        switch (dataType) {
            case INT1: {
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                DataTypeCodec.binaryEncodeInt1((Number)value, buffer);
                break;
            }
            case INT2: {
                DataTypeCodec.binaryEncodeInt2((Number)value, buffer);
                break;
            }
            case INT3: {
                DataTypeCodec.binaryEncodeInt3((Number)value, buffer);
                break;
            }
            case INT4: {
                DataTypeCodec.binaryEncodeInt4((Number)value, buffer);
                break;
            }
            case INT8: {
                DataTypeCodec.binaryEncodeInt8((Number)value, buffer);
                break;
            }
            case FLOAT: {
                DataTypeCodec.binaryEncodeFloat((Number)value, buffer);
                break;
            }
            case DOUBLE: {
                DataTypeCodec.binaryEncodeDouble((Number)value, buffer);
                break;
            }
            case NUMERIC: {
                DataTypeCodec.binaryEncodeNumeric((Numeric)value, buffer, charset);
                break;
            }
            case BLOB: {
                DataTypeCodec.binaryEncodeBlob((Buffer)value, buffer);
                break;
            }
            case DATE: {
                DataTypeCodec.binaryEncodeDate((LocalDate)value, buffer);
                break;
            }
            case TIME: {
                if (value instanceof LocalTime) {
                    DataTypeCodec.binaryEncodeTime((LocalTime)value, buffer);
                    break;
                }
                DataTypeCodec.binaryEncodeTime((Duration)value, buffer);
                break;
            }
            case DATETIME: {
                DataTypeCodec.binaryEncodeDatetime((LocalDateTime)value, buffer);
                break;
            }
            default: {
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    DataTypeCodec.binaryEncodeJson(value, buffer, charset);
                    return;
                }
                if (value == Tuple.JSON_NULL) {
                    BufferUtils.writeLengthEncodedString(buffer, "null", charset);
                    break;
                }
                DataTypeCodec.binaryEncodeText(String.valueOf(value), buffer, charset);
            }
        }
    }

    public static Object decodeBinary(DataType dataType, int collationId, int columnDefinitionFlags, ByteBuf buffer) {
        switch (dataType) {
            case INT1: {
                if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                    return DataTypeCodec.binaryDecodeUnsignedInt1(buffer);
                }
                return DataTypeCodec.binaryDecodeInt1(buffer);
            }
            case YEAR: {
                return DataTypeCodec.binaryDecodeInt2(buffer);
            }
            case INT2: {
                if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                    return DataTypeCodec.binaryDecodeUnsignedInt2(buffer);
                }
                return DataTypeCodec.binaryDecodeInt2(buffer);
            }
            case INT3: {
                if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                    return DataTypeCodec.binaryDecodeUnsignedInt3(buffer);
                }
                return DataTypeCodec.binaryDecodeInt3(buffer);
            }
            case INT4: {
                if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                    return DataTypeCodec.binaryDecodeUnsignedInt4(buffer);
                }
                return DataTypeCodec.binaryDecodeInt4(buffer);
            }
            case INT8: {
                if (DataTypeCodec.isUnsignedNumeric(columnDefinitionFlags)) {
                    return DataTypeCodec.binaryDecodeUnsignedInt8(buffer);
                }
                return DataTypeCodec.binaryDecodeInt8(buffer);
            }
            case FLOAT: {
                return DataTypeCodec.binaryDecodeFloat(buffer);
            }
            case DOUBLE: {
                return DataTypeCodec.binaryDecodeDouble(buffer);
            }
            case BIT: {
                return DataTypeCodec.binaryDecodeBit(buffer);
            }
            case NUMERIC: {
                return DataTypeCodec.binaryDecodeNumeric(collationId, buffer);
            }
            case DATE: {
                return DataTypeCodec.binaryDecodeDate(buffer);
            }
            case TIME: {
                return DataTypeCodec.binaryDecodeTime(buffer);
            }
            case DATETIME: 
            case TIMESTAMP: {
                return DataTypeCodec.binaryDecodeDatetime(buffer);
            }
            case JSON: {
                return DataTypeCodec.binaryDecodeJson(collationId, buffer);
            }
        }
        return DataTypeCodec.binaryDecodeBlobOrText(collationId, columnDefinitionFlags, buffer);
    }

    public static DataType inferDataTypeByEncodingValue(Object value) {
        if (value == null) {
            return DataType.NULL;
        }
        if (value instanceof Byte) {
            return DataType.INT1;
        }
        if (value instanceof Boolean) {
            return DataType.INT1;
        }
        if (value instanceof Short) {
            return DataType.INT2;
        }
        if (value instanceof Integer) {
            return DataType.INT4;
        }
        if (value instanceof Long) {
            return DataType.INT8;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof Duration || value instanceof LocalTime) {
            return DataType.TIME;
        }
        if (value instanceof Buffer) {
            return DataType.BLOB;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATETIME;
        }
        return DataType.STRING;
    }

    private static void binaryEncodeInt1(Number value, ByteBuf buffer) {
        buffer.writeByte((int)value.byteValue());
    }

    private static void binaryEncodeInt2(Number value, ByteBuf buffer) {
        buffer.writeShortLE(value.intValue());
    }

    private static void binaryEncodeInt3(Number value, ByteBuf buffer) {
        buffer.writeMediumLE(value.intValue());
    }

    private static void binaryEncodeInt4(Number value, ByteBuf buffer) {
        buffer.writeIntLE(value.intValue());
    }

    private static void binaryEncodeInt8(Number value, ByteBuf buffer) {
        buffer.writeLongLE(value.longValue());
    }

    private static void binaryEncodeFloat(Number value, ByteBuf buffer) {
        buffer.writeFloatLE(value.floatValue());
    }

    private static void binaryEncodeDouble(Number value, ByteBuf buffer) {
        buffer.writeDoubleLE(value.doubleValue());
    }

    private static void binaryEncodeNumeric(Numeric value, ByteBuf buffer, Charset charset) {
        BufferUtils.writeLengthEncodedString(buffer, value.toString(), charset);
    }

    private static void binaryEncodeText(String value, ByteBuf buffer, Charset charset) {
        BufferUtils.writeLengthEncodedString(buffer, value, charset);
    }

    private static void binaryEncodeBlob(Buffer value, ByteBuf buffer) {
        BufferUtils.writeLengthEncodedInteger(buffer, value.length());
        buffer.writeBytes(value.getByteBuf());
    }

    private static void binaryEncodeDate(LocalDate value, ByteBuf buffer) {
        buffer.writeByte(4);
        buffer.writeShortLE(value.getYear());
        buffer.writeByte(value.getMonthValue());
        buffer.writeByte(value.getDayOfMonth());
    }

    private static void binaryEncodeTime(LocalTime value, ByteBuf buffer) {
        int hour = value.getHour();
        int minute = value.getMinute();
        int second = value.getSecond();
        int nano = value.getNano();
        if (nano == 0) {
            if (hour == 0 && minute == 0 && second == 0) {
                buffer.writeByte(0);
            } else {
                buffer.writeByte(8);
                buffer.writeByte(0);
                buffer.writeIntLE(0);
                buffer.writeByte(hour);
                buffer.writeByte(minute);
                buffer.writeByte(second);
            }
        } else {
            int microSecond = nano / 1000;
            buffer.writeByte(12);
            buffer.writeByte(0);
            buffer.writeIntLE(0);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
            buffer.writeIntLE(microSecond);
        }
    }

    private static void binaryEncodeTime(Duration value, ByteBuf buffer) {
        int microSecond;
        long secondsOfDuration = value.getSeconds();
        int nanosOfDuration = value.getNano();
        if (secondsOfDuration == 0L && nanosOfDuration == 0) {
            buffer.writeByte(0);
            return;
        }
        int isNegative = 0;
        if (secondsOfDuration < 0L) {
            isNegative = 1;
            secondsOfDuration = -secondsOfDuration;
        }
        int days = (int)(secondsOfDuration / 86400L);
        int secondsOfADay = (int)(secondsOfDuration % 86400L);
        int hour = secondsOfADay / 3600;
        int minute = secondsOfADay % 3600 / 60;
        int second = secondsOfADay % 60;
        if (nanosOfDuration == 0) {
            buffer.writeByte(8);
            buffer.writeByte(isNegative);
            buffer.writeIntLE(days);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
            return;
        }
        if (isNegative == 1 && nanosOfDuration > 0) {
            --second;
            microSecond = (1000000000 - nanosOfDuration) / 1000;
        } else {
            microSecond = nanosOfDuration / 1000;
        }
        buffer.writeByte(12);
        buffer.writeByte(isNegative);
        buffer.writeIntLE(days);
        buffer.writeByte(hour);
        buffer.writeByte(minute);
        buffer.writeByte(second);
        buffer.writeIntLE(microSecond);
    }

    private static void binaryEncodeDatetime(LocalDateTime value, ByteBuf buffer) {
        int year = value.getYear();
        int month = value.getMonthValue();
        int day = value.getDayOfMonth();
        int hour = value.getHour();
        int minute = value.getMinute();
        int second = value.getSecond();
        int microsecond = value.getNano() / 1000;
        if (hour == 0 && minute == 0 && second == 0 && microsecond == 0) {
            buffer.writeByte(4);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
        } else if (microsecond == 0) {
            buffer.writeByte(7);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
        } else {
            buffer.writeByte(11);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
            buffer.writeIntLE(microsecond);
        }
    }

    private static void binaryEncodeJson(Object value, ByteBuf buffer, Charset charset) {
        BufferUtils.writeLengthEncodedString(buffer, Json.encode((Object)value), charset);
    }

    private static Byte binaryDecodeInt1(ByteBuf buffer) {
        return buffer.readByte();
    }

    private static Short binaryDecodeUnsignedInt1(ByteBuf buffer) {
        return buffer.readUnsignedByte();
    }

    private static Short binaryDecodeInt2(ByteBuf buffer) {
        return buffer.readShortLE();
    }

    private static Integer binaryDecodeUnsignedInt2(ByteBuf buffer) {
        return buffer.readUnsignedShortLE();
    }

    private static Integer binaryDecodeInt3(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    private static Integer binaryDecodeUnsignedInt3(ByteBuf buffer) {
        return buffer.readIntLE() & 0xFFFFFF;
    }

    private static Integer binaryDecodeInt4(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    private static Long binaryDecodeUnsignedInt4(ByteBuf buffer) {
        return buffer.readUnsignedIntLE();
    }

    private static Long binaryDecodeInt8(ByteBuf buffer) {
        return buffer.readLongLE();
    }

    private static Numeric binaryDecodeUnsignedInt8(ByteBuf buffer) {
        byte[] bigIntValue = new byte[8];
        buffer.readBytes(bigIntValue);
        for (int i = 0; i < 4; ++i) {
            byte tmp = bigIntValue[i];
            bigIntValue[i] = bigIntValue[7 - i];
            bigIntValue[7 - i] = tmp;
        }
        BigInteger value = new BigInteger(1, bigIntValue);
        return Numeric.create((Number)value);
    }

    private static Float binaryDecodeFloat(ByteBuf buffer) {
        return Float.valueOf(buffer.readFloatLE());
    }

    private static Double binaryDecodeDouble(ByteBuf buffer) {
        return buffer.readDoubleLE();
    }

    private static Long binaryDecodeBit(ByteBuf buffer) {
        int length = (int)BufferUtils.readLengthEncodedInteger(buffer);
        int idx = buffer.readerIndex();
        Long result = DataTypeCodec.decodeBit(buffer, buffer.readerIndex(), length);
        buffer.readerIndex(idx + length);
        return result;
    }

    private static Numeric binaryDecodeNumeric(int collationId, ByteBuf buffer) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return Numeric.parse((String)BufferUtils.readLengthEncodedString(buffer, charset));
    }

    private static Object binaryDecodeBlobOrText(int collationId, int columnDefinitionFlags, ByteBuf buffer) {
        if (collationId == MySQLCollation.binary.collationId()) {
            return DataTypeCodec.binaryDecodeBlob(buffer);
        }
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return DataTypeCodec.binaryDecodeText(charset, buffer);
    }

    private static Buffer binaryDecodeBlob(ByteBuf buffer) {
        int len = (int)BufferUtils.readLengthEncodedInteger(buffer);
        Buffer target = Buffer.buffer((int)len);
        target.appendBuffer(Buffer.buffer((ByteBuf)buffer.slice(buffer.readerIndex(), len)));
        buffer.skipBytes(len);
        return target;
    }

    private static String binaryDecodeText(Charset charset, ByteBuf buffer) {
        return BufferUtils.readLengthEncodedString(buffer, charset);
    }

    private static LocalDateTime binaryDecodeDatetime(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            return null;
        }
        byte length = buffer.readByte();
        if (length == 0) {
            return null;
        }
        short year = buffer.readShortLE();
        byte month = buffer.readByte();
        byte day = buffer.readByte();
        if (length == 4) {
            return LocalDateTime.of((int)year, month, (int)day, 0, 0, 0);
        }
        byte hour = buffer.readByte();
        byte minute = buffer.readByte();
        byte second = buffer.readByte();
        if (length == 11) {
            int microsecond = buffer.readIntLE();
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second, microsecond * 1000);
        }
        if (length == 7) {
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second, 0);
        }
        throw new DecoderException("Invalid Datetime");
    }

    private static LocalDate binaryDecodeDate(ByteBuf buffer) {
        return DataTypeCodec.binaryDecodeDatetime(buffer).toLocalDate();
    }

    private static Duration binaryDecodeTime(ByteBuf buffer) {
        byte length = buffer.readByte();
        if (length == 0) {
            return Duration.ZERO;
        }
        boolean isNegative = buffer.readByte() == 1;
        int days = buffer.readIntLE();
        byte hour = buffer.readByte();
        byte minute = buffer.readByte();
        byte second = buffer.readByte();
        if (isNegative) {
            days = -days;
            hour = -hour;
            minute = -minute;
            second = -second;
        }
        if (length == 8) {
            return Duration.ofDays(days).plusHours(hour).plusMinutes(minute).plusSeconds(second);
        }
        if (length == 12) {
            long microsecond = buffer.readUnsignedIntLE();
            if (isNegative) {
                microsecond = -microsecond;
            }
            return Duration.ofDays(days).plusHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(microsecond * 1000L);
        }
        throw new DecoderException("Invalid time format");
    }

    private static Object binaryDecodeJson(int collationId, ByteBuf buffer) {
        int length = (int)BufferUtils.readLengthEncodedInteger(buffer);
        Object result = DataTypeCodec.textDecodeJson(collationId, buffer, buffer.readerIndex(), length);
        buffer.skipBytes(length);
        return result;
    }

    private static Byte textDecodeInt1(ByteBuf buffer, int index, int length) {
        return (byte)CommonCodec.decodeDecStringToLong((int)index, (int)length, (ByteBuf)buffer);
    }

    private static Short textDecodeInt2(ByteBuf buffer, int index, int length) {
        return (short)CommonCodec.decodeDecStringToLong((int)index, (int)length, (ByteBuf)buffer);
    }

    private static Integer textDecodeInt3(ByteBuf buffer, int index, int length) {
        return (int)CommonCodec.decodeDecStringToLong((int)index, (int)length, (ByteBuf)buffer);
    }

    private static Integer textDecodeInt4(ByteBuf buffer, int index, int length) {
        return (int)CommonCodec.decodeDecStringToLong((int)index, (int)length, (ByteBuf)buffer);
    }

    private static Long textDecodeInt8(ByteBuf buffer, int index, int length) {
        return CommonCodec.decodeDecStringToLong((int)index, (int)length, (ByteBuf)buffer);
    }

    private static Float textDecodeFloat(int collationId, ByteBuf buffer, int index, int length) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return Float.valueOf(Float.parseFloat(buffer.toString(index, length, charset)));
    }

    private static Double textDecodeDouble(int collationId, ByteBuf buffer, int index, int length) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return Double.parseDouble(buffer.toString(index, length, charset));
    }

    private static Long textDecodeBit(ByteBuf buffer, int index, int length) {
        return DataTypeCodec.decodeBit(buffer, index, length);
    }

    private static Number textDecodeNUMERIC(int collationId, ByteBuf buff, int index, int length) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return Numeric.parse((String)buff.toString(index, length, charset));
    }

    private static Object textDecodeBlobOrText(int collationId, int columnDefinitionFlags, ByteBuf buffer, int index, int length) {
        if (collationId == MySQLCollation.binary.collationId()) {
            return DataTypeCodec.textDecodeBlob(buffer, index, length);
        }
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        return DataTypeCodec.textDecodeText(charset, buffer, index, length);
    }

    private static Buffer textDecodeBlob(ByteBuf buffer, int index, int length) {
        ByteBuf copy = Unpooled.buffer((int)length);
        copy.writeBytes(buffer, index, length);
        return Buffer.buffer((ByteBuf)copy);
    }

    private static String textDecodeText(Charset charset, ByteBuf buffer, int index, int length) {
        return buffer.toString(index, length, charset);
    }

    private static LocalDate textDecodeDate(int collationId, ByteBuf buffer, int index, int length) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        String cs = buffer.toString(index, length, charset);
        return LocalDate.parse(cs);
    }

    private static Duration textDecodeTime(int collationId, ByteBuf buffer, int index, int length) {
        String[] timeElements;
        boolean isNegative;
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        String timeString = buffer.toString(index, length, charset);
        boolean bl = isNegative = timeString.charAt(0) == '-';
        if (isNegative) {
            timeString = timeString.substring(1);
        }
        if ((timeElements = timeString.split(":")).length != 3) {
            throw new DecoderException("Invalid time format");
        }
        int hour = Integer.parseInt(timeElements[0]);
        int minute = Integer.parseInt(timeElements[1]);
        int second = Integer.parseInt(timeElements[2].substring(0, 2));
        long nanos = 0L;
        if (timeElements[2].length() > 2) {
            double fractionalSecondsPart = Double.parseDouble("0." + timeElements[2].substring(3));
            nanos = (long)(1.0E9 * fractionalSecondsPart);
        }
        if (isNegative) {
            return Duration.ofHours(-hour).minusMinutes(minute).minusSeconds(second).minusNanos(nanos);
        }
        return Duration.ofHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(nanos);
    }

    private static LocalDateTime textDecodeDateTime(int collationId, ByteBuf buffer, int index, int length) {
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        String cs = buffer.toString(index, length, charset);
        if (cs.equals("0000-00-00 00:00:00")) {
            return null;
        }
        return LocalDateTime.parse(cs, DATETIME_FORMAT);
    }

    private static Object textDecodeJson(int collationId, ByteBuf buffer, int index, int length) {
        int pos;
        Charset charset = MySQLCollation.getJavaCharsetByCollationId(collationId);
        CharSequence cs = buffer.getCharSequence(index, length, charset);
        JsonObject value = null;
        String s = cs.toString();
        for (pos = 0; pos < s.length() && Character.isWhitespace(s.charAt(pos)); ++pos) {
        }
        if (pos == s.length()) {
            return null;
        }
        if (s.charAt(pos) == '{') {
            value = new JsonObject(s);
        } else if (s.charAt(pos) == '[') {
            value = new JsonArray(s);
        } else {
            Object o = Json.decodeValue((String)s);
            if (o == null) {
                return Tuple.JSON_NULL;
            }
            if (o instanceof Number || o instanceof Boolean || o instanceof String) {
                return o;
            }
            return null;
        }
        return value;
    }

    private static boolean isUnsignedNumeric(int columnDefinitionFlags) {
        return (columnDefinitionFlags & 0x20) != 0;
    }

    private static Long decodeBit(ByteBuf buffer, int index, int length) {
        byte[] value = new byte[length];
        buffer.getBytes(index, value, 0, length);
        long result = 0L;
        for (byte b : value) {
            result = (long)(b & 0xFF) | result << 8;
        }
        return result;
    }
}

