/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.pubsub;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.pubsub.PgChannel;
import io.vertx.pgclient.pubsub.PgSubscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PgSubscriberImpl
implements PgSubscriber {
    private static Logger log = LoggerFactory.getLogger(PgSubscriberImpl.class);
    private static final Function<Integer, Long> DEFAULT_RECONNECT_POLICY = count -> -1L;
    private final Vertx vertx;
    private final PgConnectOptions options;
    private Map<String, ChannelList> channels = new HashMap<String, ChannelList>();
    private Function<Integer, Long> reconnectPolicy = DEFAULT_RECONNECT_POLICY;
    private PgConnection conn;
    private boolean connecting;
    private boolean closed = true;
    private Handler<Void> closeHandler;
    public static final int NAMEDATALEN = 64;
    public static final int MAX_CHANNEL_NAME_LENGTH = 63;

    public PgSubscriberImpl(Vertx vertx, PgConnectOptions options) {
        this.vertx = vertx;
        this.options = new PgConnectOptions(options);
    }

    public static String applyIdLengthLimit(String channelName) {
        return channelName.length() > 63 ? channelName.substring(0, 63) : channelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotification(PgNotification notif) {
        ArrayList handlers = new ArrayList();
        PgSubscriberImpl pgSubscriberImpl = this;
        synchronized (pgSubscriberImpl) {
            ChannelList channel = this.channels.get(notif.getChannel());
            if (channel != null) {
                channel.subs.forEach(sub -> {
                    Handler handler;
                    if (!((ChannelImpl)sub).paused && (handler = ((ChannelImpl)sub).eventHandler) != null) {
                        handlers.add(handler);
                    }
                });
            }
        }
        handlers.forEach(handler -> handler.handle((Object)notif.getPayload()));
    }

    @Override
    public synchronized PgSubscriber closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public synchronized PgSubscriber reconnectPolicy(Function<Integer, Long> policy) {
        this.reconnectPolicy = policy == null ? DEFAULT_RECONNECT_POLICY : policy;
        return this;
    }

    private synchronized void handleClose(Void v) {
        this.conn = null;
        this.checkReconnect(0);
    }

    private void checkReconnect(int count) {
        if (!this.closed) {
            Long val = this.reconnectPolicy.apply(count);
            if (val >= 0L) {
                this.tryConnect(val, (Handler<AsyncResult<Void>>)((Handler)ar -> {
                    if (ar.failed()) {
                        this.checkReconnect(count + 1);
                    }
                }));
                return;
            }
            this.closed = true;
        }
        List<Handler> all = this.channels.values().stream().flatMap(channel -> channel.subs.stream()).map(sub -> ((ChannelImpl)sub).endHandler).filter(Objects::nonNull).collect(Collectors.toList());
        this.channels.clear();
        all.forEach(handler -> handler.handle(null));
        Handler<Void> handler2 = this.closeHandler;
        if (handler2 != null) {
            handler2.handle(null);
        }
    }

    @Override
    public synchronized boolean closed() {
        return this.closed;
    }

    @Override
    public synchronized PgConnection actualConnection() {
        return this.conn;
    }

    @Override
    public synchronized PgSubscriber connect(Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            this.closed = false;
            this.tryConnect(0L, handler);
        }
        return this;
    }

    private void tryConnect(long delayMillis, Handler<AsyncResult<Void>> handler) {
        if (!this.connecting) {
            this.connecting = true;
            if (delayMillis > 0L) {
                this.vertx.setTimer(delayMillis, v -> this.doConnect(handler));
            } else {
                this.doConnect(handler);
            }
        }
    }

    private void doConnect(Handler<AsyncResult<Void>> completionHandler) {
        PgConnection.connect(this.vertx, this.options, (Handler<AsyncResult<PgConnection>>)((Handler)ar -> this.handleConnectResult(completionHandler, (AsyncResult<PgConnection>)ar)));
    }

    private synchronized void handleConnectResult(Handler<AsyncResult<Void>> completionHandler, AsyncResult<PgConnection> ar1) {
        this.connecting = false;
        if (ar1.succeeded()) {
            this.conn = (PgConnection)ar1.result();
            this.conn.notificationHandler((Handler<PgNotification>)((Handler)this::handleNotification));
            this.conn.closeHandler(this::handleClose);
            if (this.channels.size() > 0) {
                List handlers = this.channels.values().stream().flatMap(channel -> channel.subs.stream()).map(sub -> ((ChannelImpl)sub).subscribeHandler).filter(Objects::nonNull).collect(Collectors.toList());
                String sql = this.channels.values().stream().map(channel -> {
                    channel.subscribed = true;
                    return channel.quotedName;
                }).collect(Collectors.joining(";LISTEN ", "LISTEN ", ""));
                this.conn.query(sql, ar2 -> {
                    if (ar2.failed()) {
                        log.error((Object)"Cannot LISTEN to channels", ar2.cause());
                        this.conn.close();
                    } else {
                        handlers.forEach(arg_0 -> ((Vertx)this.vertx).runOnContext(arg_0));
                    }
                    completionHandler.handle((Object)ar2.mapEmpty());
                });
                return;
            }
        }
        completionHandler.handle((Object)ar1.mapEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PgSubscriberImpl pgSubscriberImpl = this;
        synchronized (pgSubscriberImpl) {
            if (!this.closed) {
                this.closed = true;
                if (this.conn != null) {
                    this.conn.close();
                }
            }
        }
    }

    @Override
    public PgChannel channel(String name) {
        return new ChannelImpl(name);
    }

    private class ChannelImpl
    implements PgChannel {
        private final String name;
        private Handler<Void> subscribeHandler;
        private Handler<String> eventHandler;
        private Handler<Void> endHandler;
        private ChannelList channel;
        private boolean paused;

        ChannelImpl(String name) {
            this.name = PgSubscriberImpl.applyIdLengthLimit(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PgChannel subscribeHandler(Handler<Void> handler) {
            PgSubscriberImpl pgSubscriberImpl = PgSubscriberImpl.this;
            synchronized (pgSubscriberImpl) {
                this.subscribeHandler = handler;
            }
            return this;
        }

        @Override
        public ChannelImpl exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelImpl handler(Handler<String> handler) {
            PgSubscriberImpl pgSubscriberImpl = PgSubscriberImpl.this;
            synchronized (pgSubscriberImpl) {
                if (handler != null) {
                    this.eventHandler = handler;
                    if (this.channel == null) {
                        this.channel = PgSubscriberImpl.this.channels.computeIfAbsent(this.name, x$0 -> new ChannelList((String)x$0));
                        this.channel.add(this);
                    }
                } else if (this.channel != null) {
                    ChannelList ch = this.channel;
                    this.channel = null;
                    ch.remove(this);
                    Handler<Void> _handler = this.endHandler;
                    if (_handler != null) {
                        _handler.handle(null);
                    }
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelImpl endHandler(Handler<Void> handler) {
            PgSubscriberImpl pgSubscriberImpl = PgSubscriberImpl.this;
            synchronized (pgSubscriberImpl) {
                this.endHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelImpl pause() {
            PgSubscriberImpl pgSubscriberImpl = PgSubscriberImpl.this;
            synchronized (pgSubscriberImpl) {
                this.paused = true;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelImpl resume() {
            PgSubscriberImpl pgSubscriberImpl = PgSubscriberImpl.this;
            synchronized (pgSubscriberImpl) {
                this.paused = false;
            }
            return this;
        }

        public ReadStream<String> fetch(long amount) {
            throw new UnsupportedOperationException();
        }
    }

    private class ChannelList {
        final String name;
        final String quotedName;
        final ArrayList<ChannelImpl> subs = new ArrayList();
        boolean subscribed;

        ChannelList(String name) {
            this.name = name;
            this.quotedName = "\"" + name.replace("\"", "\"\"") + "\"";
        }

        void add(ChannelImpl sub) {
            this.subs.add(sub);
            if (!this.subscribed && PgSubscriberImpl.this.conn != null) {
                this.subscribed = true;
                String sql = "LISTEN " + this.quotedName;
                PgSubscriberImpl.this.conn.query(sql, ar -> {
                    if (ar.succeeded()) {
                        Handler handler = sub.subscribeHandler;
                        if (handler != null) {
                            handler.handle(null);
                        }
                    } else {
                        log.error((Object)("Cannot LISTEN to channel " + this.name), ar.cause());
                    }
                });
            }
        }

        void remove(ChannelImpl sub) {
            this.subs.remove(sub);
            if (this.subs.isEmpty()) {
                PgSubscriberImpl.this.channels.remove(this.name, this);
                if (PgSubscriberImpl.this.conn != null) {
                    PgSubscriberImpl.this.conn.query("UNLISTEN " + this.quotedName, ar -> {
                        if (ar.failed()) {
                            log.error((Object)("Cannot UNLISTEN channel " + this.name), ar.cause());
                        }
                    });
                }
            }
        }
    }
}

