/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.rabbitmq.impl.Utils;
import java.io.IOException;

class ConsumerHandler
extends DefaultConsumer {
    private final Vertx vertx;
    private final Handler<AsyncResult<JsonObject>> handler;
    private final boolean includeProperties;
    private final Context handlerContext;
    private static final Logger log = LoggerFactory.getLogger(ConsumerHandler.class);

    public ConsumerHandler(Vertx vertx, Channel channel, boolean includeProperties, Handler<AsyncResult<JsonObject>> handler) {
        super(channel);
        this.handlerContext = vertx.getOrCreateContext();
        this.vertx = vertx;
        this.includeProperties = includeProperties;
        this.handler = handler;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        JsonObject msg = new JsonObject();
        msg.put("consumerTag", consumerTag);
        Utils.populate(msg, envelope);
        if (this.includeProperties) {
            Utils.put("properties", Utils.toJson(properties), msg);
        }
        try {
            msg.put("body", Utils.parse(properties, body));
            msg.put("deliveryTag", Long.valueOf(envelope.getDeliveryTag()));
            this.handlerContext.runOnContext(v -> this.handler.handle((Object)Future.succeededFuture((Object)msg)));
        }
        catch (Exception e) {
            this.handlerContext.runOnContext(v -> this.handler.handle((Object)Future.failedFuture((Throwable)e)));
        }
    }

    public void handleCancel(String consumerTag) throws IOException {
        log.debug((Object)"consumer has been cancelled unexpectedly");
    }
}

