/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;

final class ArrayStack {
    private final Object[] stack;
    private int pointer;

    ArrayStack(int size) {
        this.stack = new Object[size];
        this.pointer = -1;
    }

    <T> void push(T item) {
        this.stack[++this.pointer] = item;
    }

    <T> T pop() {
        Object o = this.stack[this.pointer];
        this.stack[this.pointer--] = null;
        return (T)o;
    }

    boolean empty() {
        return this.pointer == -1;
    }

    <T> @Nullable T peek() {
        if (this.pointer == -1) {
            return null;
        }
        return (T)this.stack[this.pointer];
    }

    int size() {
        return this.pointer + 1;
    }
}

