/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisSentinelConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.SentinelFailover;
import io.vertx.redis.client.impl.SentinelTopology;
import io.vertx.redis.client.impl.SharedSentinelTopology;
import java.util.concurrent.atomic.AtomicReference;

public class RedisSentinelClient
extends BaseRedisClient
implements Redis {
    private final RedisSentinelConnectOptions connectOptions;
    private final SharedSentinelTopology sharedTopology;
    private final AtomicReference<SentinelFailover> failover = new AtomicReference();

    public RedisSentinelClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, RedisSentinelConnectOptions connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.connectOptions = connectOptions;
        this.sharedTopology = new SharedSentinelTopology(vertx, connectOptions, this.connectionManager);
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.sharedTopology.get().onSuccess(arg_0 -> this.lambda$connect$0((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void connect(SentinelTopology topology, RedisSentinelConnectOptions connectOptions, Handler<AsyncResult<RedisConnection>> promise) {
        this.createConnectionInternal(topology, connectOptions.getRole(), (Handler<AsyncResult<PooledRedisConnection>>)((Handler)res -> {
            if (res.failed()) {
                promise.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            PooledRedisConnection conn = (PooledRedisConnection)res.result();
            if (connectOptions.getRole() == RedisRole.SENTINEL || connectOptions.getRole() == RedisRole.REPLICA) {
                promise.handle((Object)Future.succeededFuture((Object)conn));
                return;
            }
            if (!connectOptions.isAutoFailover()) {
                promise.handle((Object)Future.succeededFuture((Object)conn));
                return;
            }
            SentinelFailover failover = this.setupFailover(connectOptions.getMasterName());
            RedisSentinelConnection sentinelConn = new RedisSentinelConnection(conn, failover);
            promise.handle((Object)Future.succeededFuture((Object)sentinelConn));
        }));
    }

    private SentinelFailover setupFailover(String masterName) {
        SentinelFailover result = this.failover.get();
        if (result == null) {
            result = new SentinelFailover((Vertx)this.vertx, masterName, role -> {
                Promise promise = Promise.promise();
                this.sharedTopology.get().onSuccess(topology -> this.createConnectionInternal((SentinelTopology)topology, (RedisRole)((Object)role), (Handler<AsyncResult<PooledRedisConnection>>)promise)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
                return promise.future();
            });
            if (this.failover.compareAndSet(null, result)) {
                result.start();
            } else {
                result = this.failover.get();
            }
        }
        return result;
    }

    @Override
    public void close() {
        SentinelFailover failover = this.failover.get();
        if (failover != null) {
            failover.close();
        }
        super.close();
    }

    private void createConnectionInternal(SentinelTopology topology, RedisRole role, Handler<AsyncResult<PooledRedisConnection>> onCreate) {
        RedisURI uri;
        switch (role) {
            case SENTINEL: {
                uri = topology.getRandomSentinel();
                break;
            }
            case MASTER: {
                uri = topology.getMaster();
                break;
            }
            case REPLICA: {
                uri = topology.getRandomReplica();
                break;
            }
            default: {
                onCreate.handle((Object)Future.failedFuture((String)("Unknown role: " + (Object)((Object)role))));
                return;
            }
        }
        Request setup = null;
        if (role != RedisRole.SENTINEL && uri.select() != null) {
            setup = Request.cmd(Command.SELECT).arg(uri.select());
        }
        this.connectionManager.getConnection(uri.baseUri(), setup).onComplete(onCreate);
    }

    private /* synthetic */ void lambda$connect$0(Promise promise, SentinelTopology topology) {
        this.connect(topology, this.connectOptions, (Handler<AsyncResult<RedisConnection>>)promise);
    }
}

