/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.types.Multi;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class AttributeType
implements Multi {
    private final Map<String, Response> map;
    private final Response[] replies;
    private int count;
    private String key;

    public static AttributeType create(long length) {
        return new AttributeType(new Response[(int)length * 2]);
    }

    private AttributeType(Response[] replies) {
        this.replies = replies;
        this.count = 0;
        this.map = new HashMap<String, Response>();
    }

    @Override
    public ResponseType type() {
        return ResponseType.ATTRIBUTE;
    }

    @Override
    public void add(Response reply) {
        if (this.count % 2 == 0) {
            this.key = reply.toString();
        } else if (this.key != null) {
            this.map.put(this.key, reply);
        }
        this.replies[this.count++] = reply;
    }

    @Override
    public boolean complete() {
        return this.count == this.replies.length;
    }

    @Override
    public Response get(int index) {
        return this.replies[index];
    }

    @Override
    public Response get(String key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.replies.length;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean more = false;
        for (Map.Entry<String, Response> kv : this.map.entrySet()) {
            String key;
            if (more) {
                sb.append(", ");
            }
            if ((key = kv.getKey()) == null) {
                sb.append("null");
            } else {
                sb.append(key);
            }
            sb.append(':');
            Response value = kv.getValue();
            if (value == null) {
                sb.append("null");
            } else {
                sb.append(value);
            }
            more = true;
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Response> iterator() {
        return new Iterator<Response>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < AttributeType.this.replies.length;
            }

            @Override
            public Response next() {
                Response value = AttributeType.this.replies[this.idx];
                this.idx += 2;
                return value;
            }
        };
    }
}

