/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeArgExpression;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;

public abstract class AbstractRxGenerator
extends Generator<ClassModel> {
    private String id;

    public AbstractRxGenerator(String id) {
        this.id = id;
        this.kinds = Collections.singleton("class");
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, ModuleGen.class);
    }

    public String filename(ClassModel model) {
        ModuleInfo module = model.getModule();
        return module.translateQualifiedName(model.getFqn(), this.id) + ".java";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.generateClass(model, writer);
        return sw.toString();
    }

    private void generateClass(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        this.generateLicense(writer);
        writer.print("package ");
        writer.print(type.translatePackageName(this.id));
        writer.println(";");
        writer.println();
        writer.println("import java.util.Map;");
        this.genRxImports(model, writer);
        writer.println();
        this.generateDoc(model, writer);
        writer.println();
        writer.print("@io.vertx.lang.rx.RxGen(");
        writer.print(type.getName());
        writer.println(".class)");
        writer.print("public ");
        if (model.isConcrete()) {
            writer.print("class");
        } else {
            writer.print("interface");
        }
        writer.print(" ");
        writer.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer.print(" extends ");
            writer.print(this.genTypeName(model.getConcreteSuperType()));
        }
        ArrayList<String> interfaces = new ArrayList<String>();
        if ("io.vertx.core.buffer.Buffer".equals(type.getName())) {
            interfaces.add("io.vertx.core.shareddata.impl.ClusterSerializable");
        }
        interfaces.addAll(model.getAbstractSuperTypes().stream().map(this::genTypeName).collect(Collectors.toList()));
        if (model.isHandler()) {
            interfaces.add("io.vertx.core.Handler<" + this.genTypeName(model.getHandlerArg()) + ">");
        }
        if (model.isIterable()) {
            interfaces.add("java.lang.Iterable<" + this.genTypeName(model.getIterableArg()) + ">");
        }
        if (model.isIterator()) {
            interfaces.add("java.util.Iterator<" + this.genTypeName(model.getIteratorArg()) + ">");
        }
        if (model.isFunction()) {
            TypeInfo[] functionArgs = model.getFunctionArgs();
            interfaces.add("java.util.function.Function<" + this.genTypeName(functionArgs[0]) + ", " + this.genTypeName(functionArgs[1]) + ">");
        }
        if (!interfaces.isEmpty()) {
            writer.print(interfaces.stream().collect(Collectors.joining(", ", model.isConcrete() ? " implements " : " extends ", "")));
        }
        writer.println(" {");
        writer.println();
        if (model.isConcrete()) {
            List methods;
            if ("io.vertx.core.buffer.Buffer".equals(type.getName())) {
                writer.println("  @Override");
                writer.println("  public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {");
                writer.println("    delegate.writeToBuffer(buffer);");
                writer.println("  }");
                writer.println();
                writer.println("  @Override");
                writer.println("  public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {");
                writer.println("    return delegate.readFromBuffer(pos, buffer);");
                writer.println("  }");
                writer.println();
            }
            if ((methods = model.getMethods()).stream().noneMatch(it -> it.getParams().isEmpty() && "toString".equals(it.getName()))) {
                writer.println("  @Override");
                writer.println("  public String toString() {");
                writer.println("    return delegate.toString();");
                writer.println("  }");
                writer.println();
            }
            writer.println("  @Override");
            writer.println("  public boolean equals(Object o) {");
            writer.println("    if (this == o) return true;");
            writer.println("    if (o == null || getClass() != o.getClass()) return false;");
            writer.print("    ");
            writer.print(type.getSimpleName());
            writer.print(" that = (");
            writer.print(type.getSimpleName());
            writer.println(") o;");
            writer.println("    return delegate.equals(that.delegate);");
            writer.println("  }");
            writer.println("  ");
            writer.println("  @Override");
            writer.println("  public int hashCode() {");
            writer.println("    return delegate.hashCode();");
            writer.println("  }");
            writer.println();
            if (model.isIterable()) {
                this.generateIterableMethod(model, writer);
            }
            if (model.isIterator()) {
                this.generateIteratorMethods(model, writer);
            }
            if (model.isFunction()) {
                this.generateFunctionMethod(model, writer);
            }
            this.generateClassBody(model, model.getIfaceSimpleName(), writer);
        } else {
            writer.print("  ");
            writer.print(type.getName());
            writer.println(" getDelegate();");
            writer.println();
            for (MethodInfo method : model.getMethods()) {
                this.genMethod(model, method, Collections.emptyList(), false, writer);
            }
            if (type.getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                this.genReadStream(type.getParams(), writer);
            }
        }
        writer.println();
        writer.print("  public static ");
        writer.print(this.genOptTypeParamsDecl(type, " "));
        writer.print(type.getSimpleName());
        writer.print(this.genOptTypeParamsDecl(type, ""));
        writer.print(" newInstance(");
        writer.print(type.getName());
        writer.println(" arg) {");
        writer.print("    return arg != null ? new ");
        writer.print(type.getSimpleName());
        if (!model.isConcrete()) {
            writer.print("Impl");
        }
        writer.print(this.genOptTypeParamsDecl(type, ""));
        writer.println("(arg) : null;");
        writer.println("  }");
        if (type.getParams().size() > 0) {
            writer.println();
            writer.print("  public static ");
            writer.print(this.genOptTypeParamsDecl(type, " "));
            writer.print(type.getSimpleName());
            writer.print(this.genOptTypeParamsDecl(type, ""));
            writer.print(" newInstance(");
            writer.print(type.getName());
            writer.print(" arg");
            for (TypeParamInfo typeParam : type.getParams()) {
                writer.print(", io.vertx.lang.rx.TypeArg<");
                writer.print(typeParam.getName());
                writer.print("> __typeArg_");
                writer.print(typeParam.getName());
            }
            writer.println(") {");
            writer.print("    return arg != null ? new ");
            writer.print(type.getSimpleName());
            if (!model.isConcrete()) {
                writer.print("Impl");
            }
            writer.print(this.genOptTypeParamsDecl(type, ""));
            writer.print("(arg");
            for (TypeParamInfo typeParam : type.getParams()) {
                writer.print(", __typeArg_");
                writer.print(typeParam.getName());
            }
            writer.println(") : null;");
            writer.println("  }");
        }
        writer.println("}");
        if (!model.isConcrete()) {
            writer.println();
            writer.print("class ");
            writer.print(type.getSimpleName());
            writer.print("Impl");
            writer.print(this.genOptTypeParamsDecl(type, ""));
            writer.print(" implements ");
            writer.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
            writer.println(" {");
            this.generateClassBody(model, type.getSimpleName() + "Impl", writer);
            writer.println("}");
        }
    }

    private void generateIterableMethod(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "iterator".equals(it.getName()))) {
            TypeInfo iterableArg = model.getIterableArg();
            writer.println("  @Override");
            writer.printf("  public java.util.Iterator<%s> iterator() {%n", this.genTypeName(iterableArg));
            if (iterableArg.getKind() == ClassKind.API) {
                writer.format("    java.util.function.Function<%s, %s> conv = %s::newInstance;%n", iterableArg.getName(), this.genTypeName((TypeInfo)iterableArg.getRaw()), this.genTypeName(iterableArg));
                writer.println("    return new io.vertx.lang.rx.MappingIterator<>(delegate.iterator(), conv);");
            } else if (iterableArg.isVariable()) {
                String typeVar = iterableArg.getSimpleName();
                writer.format("    java.util.function.Function<%s, %s> conv = (java.util.function.Function<%s, %s>) __typeArg_0.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    return new io.vertx.lang.rx.MappingIterator<>(delegate.iterator(), conv);");
            } else {
                writer.println("    return delegate.iterator();");
            }
            writer.println("  }");
            writer.println();
        }
    }

    private void generateIteratorMethods(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "hasNext".equals(it.getName()))) {
            writer.println("  @Override");
            writer.println("  public boolean hasNext() {");
            writer.println("    return delegate.hasNext();");
            writer.println("  }");
            writer.println();
        }
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "next".equals(it.getName()))) {
            TypeInfo iteratorArg = model.getIteratorArg();
            writer.println("  @Override");
            writer.printf("  public %s next() {%n", this.genTypeName(iteratorArg));
            if (iteratorArg.getKind() == ClassKind.API) {
                writer.format("    return %s.newInstance(delegate.next());%n", this.genTypeName(iteratorArg));
            } else if (iteratorArg.isVariable()) {
                writer.println("    return __typeArg_0.wrap(delegate.next());");
            } else {
                writer.println("    return delegate.next();");
            }
            writer.println("  }");
            writer.println();
        }
    }

    private void generateFunctionMethod(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().size() == 1 && "apply".equals(it.getName()))) {
            String typeVar;
            TypeInfo[] functionArgs = model.getFunctionArgs();
            TypeInfo inArg = functionArgs[0];
            TypeInfo outArg = functionArgs[1];
            writer.println("  @Override");
            writer.printf("  public %s apply(%s in) {%n", this.genTypeName(outArg), this.genTypeName(inArg));
            writer.printf("    %s ret;%n", outArg.getName());
            if (inArg.getKind() == ClassKind.API) {
                writer.println("    ret = getDelegate().apply(in.getDelegate());");
            } else if (inArg.isVariable()) {
                typeVar = inArg.getSimpleName();
                writer.format("    java.util.function.Function<%s, %s> inConv = (java.util.function.Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    ret = getDelegate().apply(inConv.apply);");
            } else {
                writer.println("    ret = getDelegate().apply(in);");
            }
            if (outArg.getKind() == ClassKind.API) {
                writer.format("    java.util.function.Function<%s, %s> outConv = %s::newInstance;%n", outArg.getName(), this.genTypeName((TypeInfo)outArg.getRaw()), this.genTypeName(outArg));
                writer.println("    return outConv.apply(ret);");
            } else if (outArg.isVariable()) {
                typeVar = outArg.getSimpleName();
                writer.format("    java.util.function.Function<%s, %s> outConv = (java.util.function.Function<%s, %s>) __typeArg_1.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    return outConv.apply(ret);");
            } else {
                writer.println("    return delegate.iterator();");
            }
            writer.println("  }");
            writer.println();
        }
    }

    protected abstract void genReadStream(List<? extends TypeParamInfo> var1, PrintWriter var2);

    private void generateClassBody(ClassModel model, String constructor, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        if (model.isConcrete()) {
            writer.print("  public static final io.vertx.lang.rx.TypeArg<");
            writer.print(simpleName);
            writer.print("> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(");
            writer.print("    obj -> new ");
            writer.print(simpleName);
            writer.print("((");
            writer.print(type.getName());
            writer.println(") obj),");
            writer.print("    ");
            writer.print(simpleName);
            writer.println("::getDelegate");
            writer.println("  );");
            writer.println();
        }
        writer.print("  private final ");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        List typeParams = model.getTypeParams();
        if (typeParams.size() > 0) {
            writer.print(typeParams.stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">")));
        }
        writer.println(" delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("  public final io.vertx.lang.rx.TypeArg<");
            writer.print(typeParam.getName());
            writer.print("> __typeArg_");
            writer.print(typeParam.getIndex());
            writer.println(";");
        }
        writer.println("  ");
        writer.print("  public ");
        writer.print(constructor);
        writer.print("(");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer.println(" delegate) {");
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer.println("    super(delegate);");
        }
        writer.println("    this.delegate = delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("    this.__typeArg_");
            writer.print(typeParam.getIndex());
            writer.print(" = io.vertx.lang.rx.TypeArg.unknown();");
        }
        writer.println("  }");
        writer.println();
        if (typeParams.size() > 0) {
            writer.print("  public ");
            writer.print(constructor);
            writer.print("(");
            writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
            writer.print(" delegate");
            for (TypeParamInfo.Class typeParam : typeParams) {
                writer.print(", io.vertx.lang.rx.TypeArg<");
                writer.print(typeParam.getName());
                writer.print("> typeArg_");
                writer.print(typeParam.getIndex());
            }
            writer.println(") {");
            if (model.isConcrete() && model.getConcreteSuperType() != null) {
                writer.println("    super(delegate);");
            }
            writer.println("    this.delegate = delegate;");
            for (TypeParamInfo.Class typeParam : typeParams) {
                writer.print("    this.__typeArg_");
                writer.print(typeParam.getIndex());
                writer.print(" = typeArg_");
                writer.print(typeParam.getIndex());
                writer.println(";");
            }
            writer.println("  }");
            writer.println();
        }
        writer.print("  public ");
        writer.print(type.getName());
        writer.println(" getDelegate() {");
        writer.println("    return delegate;");
        writer.println("  }");
        writer.println();
        if (model.isReadStream()) {
            this.genToObservable(model.getReadStreamArg(), writer);
        }
        if (model.isWriteStream()) {
            this.genToSubscriber(model.getWriteStreamArg(), writer);
        }
        ArrayList<String> cacheDecls = new ArrayList<String>();
        for (MethodInfo method : model.getMethods()) {
            this.genMethods(model, method, cacheDecls, true, writer);
        }
        for (MethodInfo method : model.getAnyJavaTypeMethods()) {
            this.genMethods(model, method, cacheDecls, true, writer);
        }
        for (ConstantInfo constant : model.getConstants()) {
            this.genConstant(model, constant, writer);
        }
        for (String cacheDecl : cacheDecls) {
            writer.print("  ");
            writer.print(cacheDecl);
            writer.println(";");
        }
    }

    protected abstract void genToObservable(TypeInfo var1, PrintWriter var2);

    protected abstract void genToSubscriber(TypeInfo var1, PrintWriter var2);

    protected abstract void genMethods(ClassModel var1, MethodInfo var2, List<String> var3, boolean var4, PrintWriter var5);

    protected abstract void genRxMethod(ClassModel var1, MethodInfo var2, List<String> var3, boolean var4, PrintWriter var5);

    private static TypeInfo unwrap(TypeInfo type) {
        if (type instanceof ParameterizedTypeInfo) {
            return type.getRaw();
        }
        return type;
    }

    private boolean foo(MethodInfo m1, MethodInfo m2) {
        int numParams = m1.getParams().size();
        if (m1.getName().equals(m2.getName()) && numParams == m2.getParams().size()) {
            for (int index = 0; index < numParams; ++index) {
                TypeInfo t2;
                TypeInfo t1 = AbstractRxGenerator.unwrap(m1.getParam(index).getType());
                if (t1.equals((Object)(t2 = AbstractRxGenerator.unwrap(m2.getParam(index).getType())))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected final void genMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        if (method.getKind() == MethodKind.FUTURE) {
            this.genSimpleMethod(model, method, cacheDecls, genBody, writer);
            MethodInfo copy = method.copy();
            copy.getParams().remove(copy.getParams().size() - 1);
            Optional<MethodInfo> any = Stream.concat(model.getMethods().stream(), model.getAnyJavaTypeMethods().stream()).filter(m -> this.foo((MethodInfo)m, copy)).findAny();
            if (!any.isPresent()) {
                this.startMethodTemplate(model.getType(), copy, "", writer);
                if (genBody) {
                    writer.println(" {");
                    writer.print("    ");
                    if (!copy.getReturnType().isVoid()) {
                        writer.println("return ");
                    }
                    writer.print(method.getName());
                    writer.print("(");
                    writer.print(copy.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
                    if (copy.getParams().size() > 0) {
                        writer.print(", ");
                    }
                    writer.println("ar -> { });");
                    writer.println("  }");
                    writer.println();
                } else {
                    writer.println(";");
                    writer.println();
                }
            }
            this.genRxMethod(model, method, cacheDecls, genBody, writer);
        } else {
            this.genSimpleMethod(model, method, cacheDecls, genBody, writer);
        }
    }

    private void genConstant(ClassModel model, ConstantInfo constant, PrintWriter writer) {
        Doc doc = constant.getDoc();
        if (doc != null) {
            writer.println("  /**");
            Token.toHtml((List)doc.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            writer.println("   */");
        }
        writer.print(model.isConcrete() ? "  public static final" : "");
        writer.format(" %s %s = %s;\n", this.genTypeName(constant.getType()), constant.getName(), this.genConvReturn(constant.getType(), null, model.getType().getName() + "." + constant.getName()));
    }

    protected void startMethodTemplate(ClassTypeInfo type, MethodInfo method, String deprecated, PrintWriter writer) {
        Doc doc = method.getDoc();
        if (doc != null) {
            writer.println("  /**");
            Token.toHtml((List)doc.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            for (ParamInfo param : method.getParams()) {
                writer.print("   * @param ");
                writer.print(param.getName());
                writer.print(" ");
                if (param.getDescription() != null) {
                    Token.toHtml((List)param.getDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                }
                writer.println();
            }
            if (!method.getReturnType().getName().equals("void")) {
                writer.print("   * @return ");
                if (method.getReturnDescription() != null) {
                    Token.toHtml((List)method.getReturnDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                }
                writer.println();
            }
            if (deprecated != null && deprecated.length() > 0) {
                writer.print("   * @deprecated ");
                writer.println(deprecated);
            }
            writer.println("   */");
        }
        if (method.isDeprecated() || deprecated != null && deprecated.length() > 0) {
            writer.println("  @Deprecated()");
        }
        writer.print("  public ");
        if (method.isStaticMethod()) {
            writer.print("static ");
        }
        if (method.getTypeParams().size() > 0) {
            writer.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            writer.print(" ");
        }
        writer.print(this.genTypeName(method.getReturnType()));
        writer.print(" ");
        writer.print(method.getName());
        writer.print("(");
        writer.print(method.getParams().stream().map(it -> this.genTypeName(it.getType()) + " " + it.getName()).collect(Collectors.joining(", ")));
        writer.print(")");
    }

    protected final String genTypeName(TypeInfo type) {
        if (type.isParameterized()) {
            ParameterizedTypeInfo pt = (ParameterizedTypeInfo)type;
            return this.genTypeName((TypeInfo)pt.getRaw()) + pt.getArgs().stream().map(this::genTypeName).collect(Collectors.joining(", ", "<", ">"));
        }
        if (type.getKind() == ClassKind.API) {
            return type.translateName(this.id);
        }
        return type.getSimpleName();
    }

    protected String genFutureMethodName(MethodInfo method) {
        return "rx" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1);
    }

    protected final void genSimpleMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        this.startMethodTemplate(type, method, "", writer);
        if (genBody) {
            writer.println(" { ");
            if (method.isFluent()) {
                writer.print("    ");
                writer.print(this.genInvokeDelegate(model, method));
                writer.println(";");
                if (method.getReturnType().isVariable()) {
                    writer.print("    return (");
                    writer.print(method.getReturnType().getName());
                    writer.println(") this;");
                } else {
                    writer.println("    return this;");
                }
            } else if (method.getReturnType().getName().equals("void")) {
                writer.print("    ");
                writer.print(this.genInvokeDelegate(model, method));
                writer.println(";");
            } else {
                if (method.isCacheReturn()) {
                    writer.print("    if (cached_");
                    writer.print(cacheDecls.size());
                    writer.println(" != null) {");
                    writer.print("      return cached_");
                    writer.print(cacheDecls.size());
                    writer.println(";");
                    writer.println("    }");
                }
                TypeInfo returnType = method.getReturnType();
                String cachedType = method.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : this.genTypeName(returnType);
                writer.print("    ");
                writer.print(this.genTypeName(returnType));
                writer.print(" ret = ");
                writer.print(this.genConvReturn(returnType, method, this.genInvokeDelegate(model, method)));
                writer.println(";");
                if (method.isCacheReturn()) {
                    writer.print("    cached_");
                    writer.print(cacheDecls.size());
                    writer.println(" = ret;");
                    cacheDecls.add("private" + (method.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + cacheDecls.size());
                }
                writer.println("    return ret;");
            }
            writer.println("  }");
        } else {
            writer.println(";");
        }
        writer.println();
    }

    private void generateDoc(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        Doc doc = model.getDoc();
        if (doc != null) {
            writer.println("/**");
            Token.toHtml((List)doc.getTokens(), (String)" *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            writer.println(" *");
            writer.println(" * <p/>");
            writer.print(" * NOTE: This class has been automatically generated from the {@link ");
            writer.print(type.getName());
            writer.println(" original} non RX-ified interface using Vert.x codegen.");
            writer.println(" */");
        }
    }

    protected void genRxImports(ClassModel model, PrintWriter writer) {
        for (ClassTypeInfo importedType : model.getImportedTypes()) {
            if (importedType.getKind() == ClassKind.API || importedType.getPackageName().equals("java.lang")) continue;
            this.addImport(importedType, false, writer);
        }
    }

    private void addImport(ClassTypeInfo type, boolean translate, PrintWriter writer) {
        writer.print("import ");
        if (translate) {
            writer.print(type.translateName(this.id));
        } else {
            writer.print(type.toString());
        }
        writer.println(";");
    }

    private String genInvokeDelegate(ClassModel model, MethodInfo method) {
        StringBuilder ret = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType((String)model.getIfaceFQCN())) : new StringBuilder("delegate");
        ret.append(".").append(method.getName()).append("(");
        int index = 0;
        for (ParamInfo param : method.getParams()) {
            String adapterFunction;
            ParameterizedTypeInfo parameterizedType;
            TypeInfo type;
            if (index > 0) {
                ret.append(", ");
            }
            if ((type = param.getType()).isParameterized() && type.getRaw().getName().equals("rx.Observable")) {
                parameterizedType = (ParameterizedTypeInfo)type;
                adapterFunction = parameterizedType.getArg(0).isVariable() ? "java.util.function.Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
                ret.append("io.vertx.rx.java.ReadStreamSubscriber.asReadStream(").append(param.getName()).append(",").append(adapterFunction).append(").resume()");
            } else if (type.isParameterized() && (type.getRaw().getName().equals("io.reactivex.Flowable") || type.getRaw().getName().equals("io.reactivex.Observable"))) {
                parameterizedType = (ParameterizedTypeInfo)type;
                adapterFunction = parameterizedType.getArg(0).isVariable() ? "java.util.function.Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
                ret.append("io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(").append(param.getName()).append(",").append(adapterFunction).append(").resume()");
            } else {
                ret.append(this.genConvParam(type, method, param.getName()));
            }
            ++index;
        }
        ret.append(")");
        return ret.toString();
    }

    private boolean isSameType(TypeInfo type, MethodInfo method) {
        ClassKind kind = type.getKind();
        if (kind.basic || kind.json || kind == ClassKind.DATA_OBJECT || kind == ClassKind.ENUM || kind == ClassKind.OTHER || kind == ClassKind.THROWABLE || kind == ClassKind.VOID) {
            return true;
        }
        if (kind == ClassKind.OBJECT) {
            if (type.isVariable()) {
                return !this.isReified((TypeVariableInfo)type, method);
            }
            return true;
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.LIST || kind == ClassKind.SET || kind == ClassKind.ASYNC_RESULT) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.MAP) {
                return this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.HANDLER) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.FUNCTION) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method) && this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
        }
        return false;
    }

    private String genConvParam(TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (this.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return typeArg + ".<" + type.getName() + ">unwrap(" + expr + ")";
            }
            return expr;
        }
        if (kind == ClassKind.API) {
            return expr + ".getDelegate()";
        }
        if (kind == ClassKind.CLASS_TYPE) {
            return "io.vertx.lang." + this.id + ".Helper.unwrap(" + expr + ")";
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo eventType = parameterizedTypeInfo.getArg(0);
                ClassKind eventKind = eventType.getKind();
                if (eventKind == ClassKind.ASYNC_RESULT) {
                    TypeInfo resultType = ((ParameterizedTypeInfo)eventType).getArg(0);
                    return "new Handler<AsyncResult<" + resultType.getName() + ">>() {\n      public void handle(AsyncResult<" + resultType.getName() + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + this.genConvReturn(resultType, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + eventType.getName() + ">() {\n      public void handle(" + eventType.getName() + " event) {\n        " + expr + ".handle(" + this.genConvReturn(eventType, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.FUNCTION) {
                TypeInfo argType = parameterizedTypeInfo.getArg(0);
                TypeInfo retType = parameterizedTypeInfo.getArg(1);
                return "new java.util.function.Function<" + argType.getName() + "," + retType.getName() + ">() {\n      public " + retType.getName() + " apply(" + argType.getName() + " arg) {\n        " + this.genTypeName(retType) + " ret = " + expr + ".apply(" + this.genConvReturn(argType, method, "arg") + ");\n        return " + this.genConvParam(retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvParam(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(java.util.stream.Collectors.toMap(e -> e.getKey(), e -> " + this.genConvParam(parameterizedTypeInfo.getArg(1), method, "e.getValue()") + "))";
            }
        }
        return expr;
    }

    private boolean isReified(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return true;
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        return typeArg != null && typeArg.isClassType();
    }

    private String genTypeArg(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return "__typeArg_" + typeVar.getParam().getIndex();
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        if (typeArg != null) {
            if (typeArg.isClassType()) {
                return "io.vertx.lang.rx.TypeArg.of(" + typeArg.getParam().getName() + ")";
            }
            return typeArg.getParam().getName() + ".__typeArg_" + typeArg.getIndex();
        }
        return null;
    }

    private String genConvReturn(TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return "(" + type.getName() + ")" + typeArg + ".wrap(" + expr + ")";
            }
            return "(" + type.getSimpleName() + ") " + expr;
        }
        if (this.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.API) {
            StringBuilder tmp = new StringBuilder(type.getRaw().translateName(this.id));
            tmp.append(".newInstance(");
            tmp.append(expr);
            if (type.isParameterized()) {
                ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
                for (TypeInfo arg : parameterizedTypeInfo.getArgs()) {
                    String resolved;
                    tmp.append(", ");
                    ClassKind argKind = arg.getKind();
                    if (argKind == ClassKind.API) {
                        tmp.append("(io.vertx.lang.rx.TypeArg)").append(arg.getRaw().translateName(this.id)).append(".__TYPE_ARG");
                        continue;
                    }
                    String typeArg = "io.vertx.lang.rx.TypeArg.unknown()";
                    if (argKind == ClassKind.OBJECT && arg.isVariable() && (resolved = this.genTypeArg((TypeVariableInfo)arg, method)) != null) {
                        typeArg = resolved;
                    }
                    tmp.append(typeArg);
                }
            }
            tmp.append(")");
            return tmp.toString();
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo abc = parameterizedTypeInfo.getArg(0);
                if (abc.getKind() == ClassKind.ASYNC_RESULT) {
                    TypeInfo tutu = ((ParameterizedTypeInfo)abc).getArg(0);
                    return "new Handler<AsyncResult<" + this.genTypeName(tutu) + ">>() {\n      public void handle(AsyncResult<" + this.genTypeName(tutu) + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + this.genConvParam(tutu, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + this.genTypeName(abc) + ">() {\n      public void handle(" + this.genTypeName(abc) + " event) {\n          " + expr + ".handle(" + this.genConvParam(abc, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvReturn(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(java.util.stream.Collectors.toMap(_e -> _e.getKey(), _e -> " + this.genConvReturn(parameterizedTypeInfo.getArg(1), method, "_e.getValue()") + "))";
            }
        }
        return expr;
    }

    private String genOptTypeParamsDecl(ClassTypeInfo type, String deflt) {
        if (type.getParams().size() > 0) {
            return type.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">"));
        }
        return deflt;
    }

    private void generateLicense(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright 2014 Red Hat, Inc.");
        writer.println(" *");
        writer.println(" * Red Hat licenses this file to you under the Apache License, version 2.0");
        writer.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer.println(" * License.  You may obtain a copy of the License at:");
        writer.println(" *");
        writer.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer.println(" *");
        writer.println(" * Unless required by applicable law or agreed to in writing, software");
        writer.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer.println(" * License for the specific language governing permissions and limitations");
        writer.println(" * under the License.");
        writer.println(" */");
        writer.println();
    }

    private String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.DATA_OBJECT) {
                return "{@link " + rawType.getName() + "}";
            }
            if (rawType.getKind() == ClassKind.API) {
                Element elt = link.getTargetElement();
                String eltKind = elt.getKind().name();
                String ret = "{@link " + rawType.translateName(this.id);
                if ("METHOD".equals(eltKind)) {
                    ret = ret + "#" + elt.getSimpleName().toString();
                }
                if (label.length() > 0) {
                    ret = ret + " " + label;
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + rawType.getName() + "}";
    }
}

