/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
extends Future<HttpClientResponse>
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        super((io.vertx.core.Future)delegate);
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Future<HttpClientResponse> onComplete(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.onComplete((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Future<HttpClientResponse> onComplete() {
        return this.onComplete((Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    @Override
    public Single<HttpClientResponse> rxOnComplete() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.onComplete((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    @Override
    public Future<HttpClientResponse> onSuccess(final Handler<HttpClientResponse> handler) {
        this.delegate.onSuccess((Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                handler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public Future<HttpClientResponse> onFailure(Handler<Throwable> handler) {
        this.delegate.onFailure(handler);
        return this;
    }

    @Override
    public Handler<AsyncResult<HttpClientResponse>> getHandler() {
        Handler<AsyncResult<HttpClientResponse>> ret = new Handler<AsyncResult<HttpClientResponse>>(){

            public void handle(AsyncResult<HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    HttpClientRequest.this.delegate.getHandler().handle((Object)io.vertx.core.Future.succeededFuture((Object)((HttpClientResponse)ar.result()).getDelegate()));
                } else {
                    HttpClientRequest.this.delegate.getHandler().handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        };
        return ret;
    }

    @Override
    public HttpClientResponse result() {
        HttpClientResponse ret = HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)this.delegate.result());
        return ret;
    }

    @Override
    public <U> Future<U> flatMap(final Function<HttpClientResponse, Future<U>> mapper) {
        Future ret = Future.newInstance(this.delegate.flatMap(new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)mapper.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public <U> Future<U> compose(final Function<HttpClientResponse, Future<U>> mapper) {
        Future ret = Future.newInstance(this.delegate.compose(new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)mapper.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public <U> Future<U> compose(final Function<HttpClientResponse, Future<U>> successMapper, final Function<Throwable, Future<U>> failureMapper) {
        Future ret = Future.newInstance(this.delegate.compose(new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)successMapper.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        }, new Function<Throwable, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(Throwable arg) {
                Future ret = (Future)failureMapper.apply(arg);
                return ret.getDelegate();
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public <U> Future<U> map(final Function<HttpClientResponse, U> mapper) {
        Future ret = Future.newInstance(this.delegate.map(new Function<io.vertx.core.http.HttpClientResponse, U>(){

            @Override
            public U apply(io.vertx.core.http.HttpClientResponse arg) {
                Object ret = mapper.apply(HttpClientResponse.newInstance(arg));
                return ret;
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<HttpClientResponse> recover(final Function<Throwable, Future<HttpClientResponse>> mapper) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.recover((Function)new Function<Throwable, io.vertx.core.Future<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public io.vertx.core.Future<io.vertx.core.http.HttpClientResponse> apply(Throwable arg) {
                Future ret = (Future)mapper.apply(arg);
                return ret.getDelegate();
            }
        }), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwise(final Function<Throwable, HttpClientResponse> mapper) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwise((Function)new Function<Throwable, io.vertx.core.http.HttpClientResponse>(){

            @Override
            public io.vertx.core.http.HttpClientResponse apply(Throwable arg) {
                HttpClientResponse ret = (HttpClientResponse)mapper.apply(arg);
                return ret.getDelegate();
            }
        }), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwise(HttpClientResponse value) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwise((Object)value.getDelegate()), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwiseEmpty() {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwiseEmpty(), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String getRawMethod() {
        String ret = this.delegate.getRawMethod();
        return ret;
    }

    public HttpClientRequest setRawMethod(String method) {
        this.delegate.setRawMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
    }

    @Override
    public void write(String chunk) {
        this.write(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
    }

    public void write(String chunk, String enc) {
        this.write(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWrite(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead(Handler<AsyncResult<HttpVersion>> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    public HttpClientRequest sendHead() {
        return this.sendHead((Handler<AsyncResult<HttpVersion>>)((Handler)ar -> {}));
    }

    public Single<HttpVersion> rxSendHead() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendHead((Handler<AsyncResult<HttpVersion>>)fut)));
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Override
    public void end(String chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    public void end(String chunk, String enc) {
        this.end(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxEnd(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest netSocket(final Handler<AsyncResult<io.vertx.rxjava.core.net.NetSocket>> handler) {
        this.delegate.netSocket((Handler)new Handler<AsyncResult<NetSocket>>(){

            public void handle(AsyncResult<NetSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)io.vertx.rxjava.core.net.NetSocket.newInstance((NetSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClientRequest netSocket() {
        return this.netSocket((Handler<AsyncResult<io.vertx.rxjava.core.net.NetSocket>>)((Handler)ar -> {}));
    }

    public Single<io.vertx.rxjava.core.net.NetSocket> rxNetSocket() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.netSocket((Handler<AsyncResult<io.vertx.rxjava.core.net.NetSocket>>)fut)));
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest setHandler(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.setHandler((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClientRequest setHandler() {
        return this.setHandler(ar -> {});
    }

    @Override
    public Single<HttpClientResponse> rxSetHandler() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setHandler((Handler)fut)));
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

