/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpServerRequest;
import io.vertx.rxjava.core.http.ServerWebSocket;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.ReadStream;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), HttpServerRequest.__TYPE_ARG);
        this.cached_0 = ret;
        return ret;
    }

    public HttpServer requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public ReadStream<ServerWebSocket> websocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(), ServerWebSocket.__TYPE_ARG);
        this.cached_1 = ret;
        return ret;
    }

    public HttpServer websocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.websocketHandler((Handler)new Handler<io.vertx.core.http.ServerWebSocket>(){

            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle((Object)ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServer listen(int port, String host) {
        return this.listen(port, host, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listen(port, host, (Handler<AsyncResult<HttpServer>>)fut)));
    }

    public HttpServer listen(SocketAddress address, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(address.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServer listen(SocketAddress address) {
        return this.listen(address, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(SocketAddress address) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listen(address, (Handler<AsyncResult<HttpServer>>)fut)));
    }

    public HttpServer listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServer listen(int port) {
        return this.listen(port, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(int port) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listen(port, (Handler<AsyncResult<HttpServer>>)fut)));
    }

    public HttpServer listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServer listen() {
        return this.listen((Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listen((Handler<AsyncResult<HttpServer>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

