/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.web.sstore;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.web.Session;
import rx.Single;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStore that = (SessionStore)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public static SessionStore create(io.vertx.rxjava.core.Vertx vertx) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static SessionStore create(io.vertx.rxjava.core.Vertx vertx, JsonObject options) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate(), (JsonObject)options));
        return ret;
    }

    public SessionStore init(io.vertx.rxjava.core.Vertx vertx, JsonObject options) {
        this.delegate.init(vertx.getDelegate(), options);
        return this;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public void get(String cookieValue, final Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.get(cookieValue, (Handler)new Handler<AsyncResult<io.vertx.ext.web.Session>>(){

            public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Session.newInstance((io.vertx.ext.web.Session)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(String cookieValue) {
        this.get(cookieValue, (Handler<AsyncResult<Session>>)((Handler)ar -> {}));
    }

    public Single<Session> rxGet(String cookieValue) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.get(cookieValue, (Handler<AsyncResult<Session>>)fut)));
    }

    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.delete(id, resultHandler);
    }

    public void delete(String id) {
        this.delete(id, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDelete(String id) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delete(id, (Handler<AsyncResult<Void>>)fut)));
    }

    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.put(session.getDelegate(), resultHandler);
    }

    public void put(Session session) {
        this.put(session, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxPut(Session session) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.put(session, (Handler<AsyncResult<Void>>)fut)));
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.clear(resultHandler);
    }

    public void clear() {
        this.clear((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClear() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clear((Handler<AsyncResult<Void>>)fut)));
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.delegate.size(resultHandler);
    }

    public void size() {
        this.size((Handler<AsyncResult<Integer>>)((Handler)ar -> {}));
    }

    public Single<Integer> rxSize() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.size((Handler<AsyncResult<Integer>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

