/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.PreparedQuery;
import io.vertx.rxjava.sqlclient.Row;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.SqlClient;
import io.vertx.rxjava.sqlclient.Transaction;
import io.vertx.rxjava.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg(obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    public SqlConnection prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public SqlConnection prepare(String sql) {
        return this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)((Handler)ar -> {}));
    }

    public Single<PreparedQuery> rxPrepare(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)fut)));
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Transaction begin() {
        Transaction ret = Transaction.newInstance(this.delegate.begin());
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public SqlConnection preparedQuery(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public SqlConnection preparedQuery(String sql) {
        return this.preparedQuery(sql, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, (Handler)fut)));
    }

    @Override
    public SqlConnection query(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public SqlConnection query(String sql) {
        return this.query(sql, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler)fut)));
    }

    @Override
    public SqlConnection preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public SqlConnection preparedQuery(String sql, Tuple arguments) {
        return this.preparedQuery(sql, arguments, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql, Tuple arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, arguments, (Handler)fut)));
    }

    @Override
    public SqlConnection preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public SqlConnection preparedBatch(String sql, List<Tuple> batch) {
        return this.preparedBatch(sql, (List)batch, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedBatch(String sql, List<Tuple> batch) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedBatch(sql, (List)batch, (Handler)fut)));
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

