/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.PreparedQuery;
import io.vertx.rxjava.sqlclient.Row;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.SqlClient;
import io.vertx.rxjava.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public Transaction prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Transaction prepare(String sql) {
        return this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)((Handler)ar -> {}));
    }

    public Single<PreparedQuery> rxPrepare(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)fut)));
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public void commit() {
        this.commit((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxCommit() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commit((Handler<AsyncResult<Void>>)fut)));
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public void rollback() {
        this.rollback((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxRollback() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rollback((Handler<AsyncResult<Void>>)fut)));
    }

    public Transaction abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    @Override
    public Transaction query(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction query(String sql) {
        return this.query(sql, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler)fut)));
    }

    @Override
    public Transaction preparedQuery(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedQuery(String sql) {
        return this.preparedQuery(sql, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, (Handler)fut)));
    }

    @Override
    public Transaction preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedQuery(String sql, Tuple arguments) {
        return this.preparedQuery(sql, arguments, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql, Tuple arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, arguments, (Handler)fut)));
    }

    @Override
    public Transaction preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedBatch(String sql, List<Tuple> batch) {
        return this.preparedBatch(sql, (List)batch, ar -> {});
    }

    @Override
    public Single<RowSet<Row>> rxPreparedBatch(String sql, List<Tuple> batch) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedBatch(sql, (List)batch, (Handler)fut)));
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

