/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.core.json.JsonObject;
import java.util.UUID;
import java.time.Instant;

/**
 * Represents an AMQP message.
 * <p>
 * Reference about the different metadata can be found on
 * <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
 * <p>
 * Note that the body is retrieved using <code>body*</code> method depending on the expected type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.amqp.AmqpMessage.class)
public class AmqpMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpMessage that = (AmqpMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AmqpMessage> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AmqpMessage((io.vertx.amqp.AmqpMessage) obj),
    AmqpMessage::getDelegate
  );

  private final io.vertx.amqp.AmqpMessage delegate;
  
  public AmqpMessage(io.vertx.amqp.AmqpMessage delegate) {
    this.delegate = delegate;
  }

  public io.vertx.amqp.AmqpMessage getDelegate() {
    return delegate;
  }

  /**
   * @return a builder to create an {@link io.vertx.reactivex.amqp.AmqpMessage}.
   */
  public static io.vertx.reactivex.amqp.AmqpMessageBuilder create() { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance(io.vertx.amqp.AmqpMessage.create());
    return ret;
  }

  /**
   * Creates a builder to create a new {@link io.vertx.reactivex.amqp.AmqpMessage} copying the metadata from the passed message.
   * @param existing an existing message, must not be <code>null</code>.
   * @return a builder to create an {@link io.vertx.reactivex.amqp.AmqpMessage}.
   */
  public static io.vertx.reactivex.amqp.AmqpMessageBuilder create(io.vertx.reactivex.amqp.AmqpMessage existing) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance(io.vertx.amqp.AmqpMessage.create(existing.getDelegate()));
    return ret;
  }

  /**
   * @return whether or not the message is durable.
   */
  public boolean isDurable() { 
    boolean ret = delegate.isDurable();
    return ret;
  }

  /**
   * @return if <code>true</code>, then this message has not been acquired by any other link. If <code>false</code>, then this message MAY have previously been acquired by another link or links.
   */
  public boolean isFirstAcquirer() { 
    boolean ret = delegate.isFirstAcquirer();
    return ret;
  }

  /**
   * @return the relative message priority. Higher numbers indicate higher priority messages. Messages with higher priorities MAY be delivered before those with lower priorities.
   */
  public int priority() { 
    int ret = delegate.priority();
    return ret;
  }

  /**
   * @return the number of unsuccessful previous attempts to deliver this message. If this value is non-zero it can be taken as an indication that the delivery might be a duplicate. On first delivery, the value is zero. It is incremented upon an outcome being settled at the sender, according to rules defined for each outcome.
   */
  public int deliveryCount() { 
    int ret = delegate.deliveryCount();
    return ret;
  }

  /**
   * @return the duration in milliseconds for which the message is to be considered "live".
   */
  public long ttl() { 
    long ret = delegate.ttl();
    return ret;
  }

  /**
   * @return the message id
   */
  public String id() { 
    String ret = delegate.id();
    return ret;
  }

  /**
   * @return the message address, also named <code>to</code> field
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * @return The address of the node to send replies to, if any.
   */
  public String replyTo() { 
    String ret = delegate.replyTo();
    return ret;
  }

  /**
   * @return The client-specific id that can be used to mark or identify messages between clients.
   */
  public String correlationId() { 
    String ret = delegate.correlationId();
    return ret;
  }

  /**
   * @return whether the body is <code>null</code>. This method returns <code>true</code> is the message does not contain a body or if the message contain a <code>null</code> AMQP value as body.
   */
  public boolean isBodyNull() { 
    boolean ret = delegate.isBodyNull();
    return ret;
  }

  /**
   * @return the boolean value contained in the body. The value must be passed as AMQP value.
   */
  public boolean bodyAsBoolean() { 
    boolean ret = delegate.bodyAsBoolean();
    return ret;
  }

  /**
   * @return the byte value contained in the body. The value must be passed as AMQP value.
   */
  public byte bodyAsByte() { 
    byte ret = delegate.bodyAsByte();
    return ret;
  }

  /**
   * @return the short value contained in the body. The value must be passed as AMQP value.
   */
  public short bodyAsShort() { 
    short ret = delegate.bodyAsShort();
    return ret;
  }

  /**
   * @return the integer value contained in the body. The value must be passed as AMQP value.
   */
  public int bodyAsInteger() { 
    int ret = delegate.bodyAsInteger();
    return ret;
  }

  /**
   * @return the long value contained in the body. The value must be passed as AMQP value.
   */
  public long bodyAsLong() { 
    long ret = delegate.bodyAsLong();
    return ret;
  }

  /**
   * @return the float value contained in the body. The value must be passed as AMQP value.
   */
  public float bodyAsFloat() { 
    float ret = delegate.bodyAsFloat();
    return ret;
  }

  /**
   * @return the double value contained in the body. The value must be passed as AMQP value.
   */
  public double bodyAsDouble() { 
    double ret = delegate.bodyAsDouble();
    return ret;
  }

  /**
   * @return the character value contained in the body. The value must be passed as AMQP value.
   */
  public char bodyAsChar() { 
    char ret = delegate.bodyAsChar();
    return ret;
  }

  /**
   * @return the bytes contained in the body. The value must be passed as AMQP data.
   */
  public io.vertx.reactivex.core.buffer.Buffer bodyAsBinary() { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance(delegate.bodyAsBinary());
    return ret;
  }

  /**
   * @return the string value contained in the body. The value must be passed as AMQP value.
   */
  public String bodyAsString() { 
    String ret = delegate.bodyAsString();
    return ret;
  }

  /**
   * @return the symbol value contained in the body. The value must be passed as AMQP value.
   */
  public String bodyAsSymbol() { 
    String ret = delegate.bodyAsSymbol();
    return ret;
  }

  /**
   * @return the list of values contained in the body. The value must be passed as AMQP value.
   */
  public <T> List<T> bodyAsList() { 
    List<T> ret = delegate.bodyAsList();
    return ret;
  }

  /**
   * @return the JSON object contained in the body. The value must be passed as AMQP data.
   */
  public JsonObject bodyAsJsonObject() { 
    JsonObject ret = delegate.bodyAsJsonObject();
    return ret;
  }

  /**
   * @return the JSON array contained in the body. The value must be passed as AMQP data.
   */
  public JsonArray bodyAsJsonArray() { 
    JsonArray ret = delegate.bodyAsJsonArray();
    return ret;
  }

  public String subject() { 
    String ret = delegate.subject();
    return ret;
  }

  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  public String contentEncoding() { 
    String ret = delegate.contentEncoding();
    return ret;
  }

  public long expiryTime() { 
    long ret = delegate.expiryTime();
    return ret;
  }

  public long creationTime() { 
    long ret = delegate.creationTime();
    return ret;
  }

  public String groupId() { 
    String ret = delegate.groupId();
    return ret;
  }

  public String replyToGroupId() { 
    String ret = delegate.replyToGroupId();
    return ret;
  }

  public long groupSequence() { 
    long ret = delegate.groupSequence();
    return ret;
  }

  /**
   * @return the message properties as JSON object.
   */
  public JsonObject applicationProperties() { 
    JsonObject ret = delegate.applicationProperties();
    return ret;
  }

  /**
   * When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   * the incoming message. It marks the message as delivered with the <code>accepted</code> status.
   * @return the current {@link io.vertx.reactivex.amqp.AmqpMessage} object
   */
  public io.vertx.reactivex.amqp.AmqpMessage accepted() { 
    delegate.accepted();
    return this;
  }

  /**
   * When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   * the incoming message as <code>rejected</code>.
   * @return the current {@link io.vertx.reactivex.amqp.AmqpMessage} object
   */
  public io.vertx.reactivex.amqp.AmqpMessage rejected() { 
    delegate.rejected();
    return this;
  }

  /**
   * When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   * the incoming message as <code>released</code>.
   * @return the current {@link io.vertx.reactivex.amqp.AmqpMessage} object
   */
  public io.vertx.reactivex.amqp.AmqpMessage released() { 
    delegate.released();
    return this;
  }

  /**
   * When receiving a message,  and when auto-acknowledgement is disabled, this method is used to acknowledge
   * the incoming message as <code>modified</code>.
   * @param didItFail pass <code>true</code> to increase the failed delivery count
   * @param wasItDeliveredHere pass <code>true</code> to prevent the re-delivery of the message
   * @return the current {@link io.vertx.reactivex.amqp.AmqpMessage} object
   */
  public io.vertx.reactivex.amqp.AmqpMessage modified(boolean didItFail, boolean wasItDeliveredHere) { 
    delegate.modified(didItFail, wasItDeliveredHere);
    return this;
  }

  /**
   * @return the timestamp value contained in the body. The value must be passed as AMQP value.
   */
  public Instant bodyAsTimestamp() { 
    Instant ret = delegate.bodyAsTimestamp();
    return ret;
  }

  /**
   * @return the UUID value contained in the body. The value must be passed as AMQP value.
   */
  public UUID bodyAsUUID() { 
    UUID ret = delegate.bodyAsUUID();
    return ret;
  }


  public static  AmqpMessage newInstance(io.vertx.amqp.AmqpMessage arg) {
    return arg != null ? new AmqpMessage(arg) : null;
  }
}
