/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * It is like , but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.Mapper original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.cassandra.Mapper.class)
public class Mapper<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Mapper that = (Mapper) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Mapper> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Mapper((io.vertx.cassandra.Mapper) obj),
    Mapper::getDelegate
  );

  private final io.vertx.cassandra.Mapper<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public Mapper(io.vertx.cassandra.Mapper delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public Mapper(io.vertx.cassandra.Mapper delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.cassandra.Mapper getDelegate() {
    return delegate;
  }

  /**
   * Asynchronous save method.
   * @param entity object to be stored in database
   * @param handler result handler
   */
  public void save(T entity, Handler<AsyncResult<Void>> handler) { 
    delegate.save(__typeArg_0.<T>unwrap(entity), handler);
  }

  /**
   * Asynchronous save method.
   * @param entity object to be stored in database
   * @return 
   */
  public Completable rxSave(T entity) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      save(entity, handler);
    });
  }

  /**
   * Asynchronous delete method based on the column values of the primary key.
   * @param primaryKey primary key used to find row to delete
   * @param handler result handler
   */
  public void delete(List<Object> primaryKey, Handler<AsyncResult<Void>> handler) { 
    delegate.delete(primaryKey, handler);
  }

  /**
   * Asynchronous delete method based on the column values of the primary key.
   * @param primaryKey primary key used to find row to delete
   * @return 
   */
  public Completable rxDelete(List<Object> primaryKey) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      delete(primaryKey, handler);
    });
  }

  /**
   * Asynchronous get method based on the column values of the primary key.
   * @param primaryKey primary key used to retrieve row
   * @param handler result handler
   */
  public void get(List<Object> primaryKey, Handler<AsyncResult<T>> handler) { 
    delegate.get(primaryKey, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Asynchronous get method based on the column values of the primary key.
   * @param primaryKey primary key used to retrieve row
   * @return 
   */
  public Single<T> rxGet(List<Object> primaryKey) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      get(primaryKey, handler);
    });
  }


  public static <T>Mapper<T> newInstance(io.vertx.cassandra.Mapper arg) {
    return arg != null ? new Mapper<T>(arg) : null;
  }

  public static <T>Mapper<T> newInstance(io.vertx.cassandra.Mapper arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Mapper<T>(arg, __typeArg_T) : null;
  }
}
