/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.json.pointer;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import java.net.URI;

/**
 * Implementation of <a href="https://tools.ietf.org/html/rfc6901">RFC6901 Json Pointers</a>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.json.pointer.JsonPointer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.json.pointer.JsonPointer.class)
public class JsonPointer {

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonPointer that = (JsonPointer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<JsonPointer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new JsonPointer((io.vertx.core.json.pointer.JsonPointer) obj),
    JsonPointer::getDelegate
  );

  private final io.vertx.core.json.pointer.JsonPointer delegate;
  
  public JsonPointer(io.vertx.core.json.pointer.JsonPointer delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.json.pointer.JsonPointer getDelegate() {
    return delegate;
  }

  /**
   * Return <code>true</code> if the pointer is a root pointer
   * @return 
   */
  public boolean isRootPointer() { 
    boolean ret = delegate.isRootPointer();
    return ret;
  }

  /**
   * Return <code>true</code> if the pointer is local (URI with only fragment)
   * @return 
   */
  public boolean isLocalPointer() { 
    boolean ret = delegate.isLocalPointer();
    return ret;
  }

  /**
   * Return <code>true</code> if this pointer is a parent pointer of <code>child</code>.
   * <br/>
   * For instance <code>"/properties"</code> pointer is parent pointer of <code>"/properties/parent"</code>
   * @param child 
   * @return 
   */
  public boolean isParent(io.vertx.reactivex.core.json.pointer.JsonPointer child) { 
    boolean ret = delegate.isParent(child.getDelegate());
    return ret;
  }

  /**
   * Build a <a href="https://tools.ietf.org/html/rfc6901#section-5">string representation</a> of the JSON Pointer
   * @return 
   */
  public String toString() { 
    String ret = delegate.toString();
    return ret;
  }

  /**
   * Append an unescaped <code>token</code> to this pointer <br/>
   * Note: If you provide escaped path the behaviour is undefined
   * @param token the unescaped reference token
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer append(String token) { 
    delegate.append(token);
    return this;
  }

  /**
   * Append the <code>index</code> as reference token to JsonPointer
   * @param index 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer append(int index) { 
    delegate.append(index);
    return this;
  }

  /**
   * Append an unescaped list of <code>tokens</code> to JsonPointer <br/>
   * Note: If you provide escaped paths the behaviour is undefined
   * @param tokens unescaped reference tokens
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer append(List<String> tokens) { 
    delegate.append(tokens);
    return this;
  }

  /**
   * Append all tokens of <code>pointer</code> to this pointer <br/>
   * Note: The base URI of this pointer will remain untouched
   * @param pointer other pointer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer append(io.vertx.reactivex.core.json.pointer.JsonPointer pointer) { 
    delegate.append(pointer.getDelegate());
    return this;
  }

  /**
   * Remove last reference token of this pointer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer parent() { 
    delegate.parent();
    return this;
  }

  /**
   * Query <code>objectToQuery</code> using the provided {@link io.vertx.reactivex.core.json.pointer.JsonPointerIterator}. <br/>
   * If you need to query Vert.x json data structures, use {@link io.vertx.reactivex.core.json.pointer.JsonPointer#queryJson}<br/>
   * Note: if this pointer is a root pointer, this function returns the provided object
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object query(Object objectToQuery, io.vertx.reactivex.core.json.pointer.JsonPointerIterator iterator) { 
    Object ret = (Object) delegate.query(objectToQuery, iterator.getDelegate());
    return ret;
  }

  /**
   * Query <code>objectToQuery</code> using the provided {@link io.vertx.reactivex.core.json.pointer.JsonPointerIterator}. If the query result is null, returns the default. <br/>
   * If you need to query Vert.x json data structures, use {@link io.vertx.reactivex.core.json.pointer.JsonPointer#queryJsonOrDefault}<br/>
   * Note: if this pointer is a root pointer, this function returns the provided object
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @param defaultValue default value if query result is null
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryOrDefault(Object objectToQuery, io.vertx.reactivex.core.json.pointer.JsonPointerIterator iterator, Object defaultValue) { 
    Object ret = (Object) delegate.queryOrDefault(objectToQuery, iterator.getDelegate(), defaultValue);
    return ret;
  }

  /**
   * Query <code>jsonElement</code>. <br/>
   * Note: if this pointer is a root pointer, this function returns the provided json element
   * @param jsonElement the json element to query
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryJson(Object jsonElement) { 
    Object ret = (Object) delegate.queryJson(jsonElement);
    return ret;
  }

  /**
   * Query <code>jsonElement</code>. If the query result is null, returns the default.<br/>
   * Note: if this pointer is a root pointer, this function returns the provided object
   * @param jsonElement the json element to query
   * @param defaultValue default value if query result is null
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryJsonOrDefault(Object jsonElement, Object defaultValue) { 
    Object ret = (Object) delegate.queryJsonOrDefault(jsonElement, defaultValue);
    return ret;
  }

  /**
   * Query <code>objectToQuery</code> tracing each element walked during the query, including the first and the result (if any).<br/>
   * The first element of the list is objectToQuery and the last is the result, or the element before the first null was encountered
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @return the stream of walked elements
   */
  public List<Object> tracedQuery(Object objectToQuery, io.vertx.reactivex.core.json.pointer.JsonPointerIterator iterator) { 
    List<Object> ret = delegate.tracedQuery(objectToQuery, iterator.getDelegate());
    return ret;
  }

  /**
   * Write <code>newElement</code> in <code>objectToWrite</code> using this pointer. The path token "-" is handled as append to end of array <br/>
   * If you need to write in Vert.x json data structures, use {@link io.vertx.reactivex.core.json.pointer.JsonPointer#writeJson} (Object)}<br/>
   * @param objectToWrite object to write
   * @param iterator the json pointer iterator that provides the logic to access to the objectToMutate
   * @param newElement object to insert
   * @param createOnMissing create objects when missing a object key or an array index
   * @return a reference to objectToWrite if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object write(Object objectToWrite, io.vertx.reactivex.core.json.pointer.JsonPointerIterator iterator, Object newElement, boolean createOnMissing) { 
    Object ret = (Object) delegate.write(objectToWrite, iterator.getDelegate(), newElement, createOnMissing);
    return ret;
  }

  /**
   * Write <code>newElement</code> in <code>jsonElement</code> using this pointer. The path token "-" is handled as append to end of array.
   * @param jsonElement json element to query and write
   * @param newElement json to insert
   * @return a reference to json if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object writeJson(Object jsonElement, Object newElement) { 
    Object ret = (Object) delegate.writeJson(jsonElement, newElement);
    return ret;
  }

  /**
   * Write <code>newElement</code> in <code>jsonElement</code> using this pointer. The path token "-" is handled as append to end of array.
   * @param jsonElement json to query and write
   * @param newElement json to insert
   * @param createOnMissing create JsonObject when missing a object key or an array index
   * @return a reference to json if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object writeJson(Object jsonElement, Object newElement, boolean createOnMissing) { 
    Object ret = (Object) delegate.writeJson(jsonElement, newElement, createOnMissing);
    return ret;
  }

  /**
   * Copy a JsonPointer
   * @return a copy of this pointer
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer copy() { 
    io.vertx.reactivex.core.json.pointer.JsonPointer ret = io.vertx.reactivex.core.json.pointer.JsonPointer.newInstance(delegate.copy());
    return ret;
  }

  /**
   * Build an empty JsonPointer
   * @return a new empty JsonPointer
   */
  public static io.vertx.reactivex.core.json.pointer.JsonPointer create() { 
    io.vertx.reactivex.core.json.pointer.JsonPointer ret = io.vertx.reactivex.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.create());
    return ret;
  }

  /**
   * Build a JsonPointer from a json pointer string
   * @param pointer the string representing a pointer
   * @return new instance of JsonPointer
   */
  public static io.vertx.reactivex.core.json.pointer.JsonPointer from(String pointer) { 
    io.vertx.reactivex.core.json.pointer.JsonPointer ret = io.vertx.reactivex.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.from(pointer));
    return ret;
  }

  /**
   * Build a <a href="https://tools.ietf.org/html/rfc6901#section-6">URI representation</a> of the JSON Pointer
   * @return 
   */
  public URI toURI() { 
    URI ret = delegate.toURI();
    return ret;
  }

  /**
   * Return the underlying URI without the fragment
   * @return 
   */
  public URI getURIWithoutFragment() { 
    URI ret = delegate.getURIWithoutFragment();
    return ret;
  }

  /**
   * Build a JsonPointer from a URI.
   * @param uri uri representing a json pointer
   * @return new instance of JsonPointer
   */
  public static io.vertx.reactivex.core.json.pointer.JsonPointer fromURI(URI uri) { 
    io.vertx.reactivex.core.json.pointer.JsonPointer ret = io.vertx.reactivex.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.fromURI(uri));
    return ret;
  }


  public static  JsonPointer newInstance(io.vertx.core.json.pointer.JsonPointer arg) {
    return arg != null ? new JsonPointer(arg) : null;
  }
}
