/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.parsetools;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
 * element fully. This parser is convenient for parsing large json structures.
 * <p/>
 * The parser also parses concatenated json streams or line delimited json streams.
 * <p/>
 * The parser can also parse entire object or array when it is convenient, for instance a very large array
 * of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
 * events.
 * <p/>
 * Whenever the parser fails to parse or process the stream, the {@link io.vertx.reactivex.core.parsetools.JsonParser#exceptionHandler} is called with
 * the cause of the failure and the current handling stops. After such event, the parser should not handle data
 * anymore.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonParser original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.parsetools.JsonParser.class)
public class JsonParser implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.parsetools.JsonEvent>, io.vertx.core.Handler<io.vertx.reactivex.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonParser that = (JsonParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<JsonParser> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new JsonParser((io.vertx.core.parsetools.JsonParser) obj),
    JsonParser::getDelegate
  );

  private final io.vertx.core.parsetools.JsonParser delegate;
  
  public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.parsetools.JsonParser getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.parsetools.JsonEvent> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.parsetools.JsonEvent> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.parsetools.JsonEvent> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.parsetools.JsonEvent, io.vertx.reactivex.core.parsetools.JsonEvent> conv = io.vertx.reactivex.core.parsetools.JsonEvent::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.parsetools.JsonEvent> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.parsetools.JsonEvent, io.vertx.reactivex.core.parsetools.JsonEvent> conv = io.vertx.reactivex.core.parsetools.JsonEvent::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.core.buffer.Buffer event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.parsetools.JsonEvent> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.parsetools.JsonEvent> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.parsetools.JsonEvent.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.parsetools.JsonEvent> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.parsetools.JsonEvent> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.parsetools.JsonEvent> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser() { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser());
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser(Observable<io.vertx.reactivex.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Handle a <code>Buffer</code>, pretty much like calling {@link io.vertx.core.Handler}.
   * @param buffer 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser write(io.vertx.reactivex.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  /**
   * End the stream, this must be called after all the json stream has been processed.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Flip the parser to emit a stream of events for each new json object.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser objectEventMode() { 
    delegate.objectEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json object.
   * </p>
   * Json object currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser objectValueMode() { 
    delegate.objectValueMode();
    return this;
  }

  /**
   * Flip the parser to emit a stream of events for each new json array.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser arrayEventMode() { 
    delegate.arrayEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json array.
   * </p>
   * Json array currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser arrayValueMode() { 
    delegate.arrayValueMode();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser handler(Handler<io.vertx.reactivex.core.parsetools.JsonEvent> handler) { 
    delegate.handler(new Handler<io.vertx.core.parsetools.JsonEvent>() {
      public void handle(io.vertx.core.parsetools.JsonEvent event) {
        handler.handle(io.vertx.reactivex.core.parsetools.JsonEvent.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }


  public static  JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
    return arg != null ? new JsonParser(arg) : null;
  }
}
