/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * A secure non blocking random number generator isolated to the current context. The PRNG is bound to the vert.x
 * context and setup to close when the context shuts down.
 * <p>
 * When applicable, use of VertxContextPRNG rather than create new PRNG objects is helpful to keep the system entropy
 * usage to the minimum avoiding potential blocking across the application.
 * <p>
 * The use of VertxContextPRNG is particularly appropriate when multiple handlers use random numbers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.VertxContextPRNG original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.VertxContextPRNG.class)
public class VertxContextPRNG {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxContextPRNG that = (VertxContextPRNG) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<VertxContextPRNG> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new VertxContextPRNG((io.vertx.ext.auth.VertxContextPRNG) obj),
    VertxContextPRNG::getDelegate
  );

  private final io.vertx.ext.auth.VertxContextPRNG delegate;
  
  public VertxContextPRNG(io.vertx.ext.auth.VertxContextPRNG delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.VertxContextPRNG getDelegate() {
    return delegate;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x context. If there is no
   * current context (i.e.: not running on the eventloop) then a {@link java.lang.IllegalStateException} is thrown.
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.reactivex.ext.auth.VertxContextPRNG current() { 
    io.vertx.reactivex.ext.auth.VertxContextPRNG ret = io.vertx.reactivex.ext.auth.VertxContextPRNG.newInstance(io.vertx.ext.auth.VertxContextPRNG.current());
    return ret;
  }

  /**
   * Get or create a secure non blocking random number generator using the current vert.x instance. Since the context
   * might be different this method will attempt to use the current context first if available and then fall back to
   * create a new instance of the PRNG.
   * @param vertx a Vert.x instance.
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.reactivex.ext.auth.VertxContextPRNG current(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.auth.VertxContextPRNG ret = io.vertx.reactivex.ext.auth.VertxContextPRNG.newInstance(io.vertx.ext.auth.VertxContextPRNG.current(vertx.getDelegate()));
    return ret;
  }

  /**
   * Returns a Base64 mime encoded String of random data with the given length. The length parameter refers to the length
   * of the String before the encoding step.
   * @param length the desired string length before Base64 encoding.
   * @return A base 64 encoded string.
   */
  public String nextString(int length) { 
    String ret = delegate.nextString(length);
    return ret;
  }

  /**
   * Returns a secure random int
   * @return random int.
   */
  public int nextInt() { 
    int ret = delegate.nextInt();
    return ret;
  }

  /**
   * Returns a secure random int, between 0 (inclusive) and the specified bound (exclusive).
   * @param bound the upper bound (exclusive), which must be positive.
   * @return random int.
   */
  public int nextInt(int bound) { 
    int ret = delegate.nextInt(bound);
    return ret;
  }


  public static  VertxContextPRNG newInstance(io.vertx.ext.auth.VertxContextPRNG arg) {
    return arg != null ? new VertxContextPRNG(arg) : null;
  }
}
