/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import java.util.List;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.CheckList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.EventOptions;


@io.vertx.lang.rx.RxGen(io.vertx.ext.consul.ConsulService.class)
public class ConsulService extends io.vertx.reactivex.ext.consul.ConsulClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulService that = (ConsulService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ConsulService> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ConsulService((io.vertx.ext.consul.ConsulService) obj),
    ConsulService::getDelegate
  );

  private final io.vertx.ext.consul.ConsulService delegate;
  
  public ConsulService(io.vertx.ext.consul.ConsulService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.consul.ConsulService getDelegate() {
    return delegate;
  }

  /**
   * Create a proxy to a service that is deployed somewhere on the event bus
   * @param vertx the Vert.x instance
   * @param address the address the service is listening on on the event bus
   * @return the service
   */
  public static io.vertx.reactivex.ext.consul.ConsulService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.consul.ConsulService ret = io.vertx.reactivex.ext.consul.ConsulService.newInstance(io.vertx.ext.consul.ConsulService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.consul.ConsulService agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  public Single<JsonObject> rxAgentInfo() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      agentInfo(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateNodes(Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  public Single<CoordinateList> rxCoordinateNodes() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateNodes(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateNodesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  public Single<CoordinateList> rxCoordinateNodesWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateNodesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  public Single<List<DcCoordinates>> rxCoordinateDatacenters() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateDatacenters(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  public Single<List<String>> rxGetKeys(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getKeys(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getKeysWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getKeysWithOptions(keyPrefix, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValue(String key, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  public Single<KeyValue> rxGetValue(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValue(key, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValueWithOptions(String key, BlockingQueryOptions options, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  public Single<KeyValue> rxGetValueWithOptions(String key, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValueWithOptions(key, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  public Completable rxDeleteValue(String key) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteValue(key, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValues(String keyPrefix, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  public Single<KeyValueList> rxGetValues(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValues(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValuesWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  public Single<KeyValueList> rxGetValuesWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValuesWithOptions(keyPrefix, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  public Completable rxDeleteValues(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteValues(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  public Single<Boolean> rxPutValue(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      putValue(key, value, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService putValueWithOptions(String key, String value, KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  public Single<Boolean> rxPutValueWithOptions(String key, String value, KeyValueOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      putValueWithOptions(key, value, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService transaction(TxnRequest request, Handler<AsyncResult<TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  public Single<TxnResponse> rxTransaction(TxnRequest request) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      transaction(request, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  public Single<String> rxCreateAclToken(AclToken token) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createAclToken(token, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  public Single<String> rxUpdateAclToken(AclToken token) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      updateAclToken(token, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  public Single<String> rxCloneAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      cloneAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listAclTokens(Handler<AsyncResult<List<AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  public Single<List<AclToken>> rxListAclTokens() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listAclTokens(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoAclToken(String id, Handler<AsyncResult<AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  public Single<AclToken> rxInfoAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  public Completable rxDestroyAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      destroyAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService fireEvent(String name, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  public Single<Event> rxFireEvent(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      fireEvent(name, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService fireEventWithOptions(String name, EventOptions options, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  public Single<Event> rxFireEventWithOptions(String name, EventOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      fireEventWithOptions(name, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listEvents(Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  public Single<EventList> rxListEvents() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listEvents(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listEventsWithOptions(EventListOptions options, Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  public Single<EventList> rxListEventsWithOptions(EventListOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listEventsWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService registerService(ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  public Completable rxRegisterService(ServiceOptions serviceOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      registerService(serviceOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService maintenanceService(MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  public Completable rxMaintenanceService(MaintenanceOptions maintenanceOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      maintenanceService(maintenanceOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  public Completable rxDeregisterService(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deregisterService(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthChecks(String service, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  public Single<CheckList> rxHealthChecks(String service) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthChecks(service, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthChecksWithOptions(String service, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  public Single<CheckList> rxHealthChecksWithOptions(String service, CheckQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthChecksWithOptions(service, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthState(HealthState healthState, Handler<AsyncResult<CheckList>> handler) { 
    delegate.healthState(healthState, handler);
    return this;
  }

  public Single<CheckList> rxHealthState(HealthState healthState) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthState(healthState, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthStateWithOptions(HealthState healthState, CheckQueryOptions checkQueryOptions, Handler<AsyncResult<CheckList>> handler) { 
    delegate.healthStateWithOptions(healthState, checkQueryOptions, handler);
    return this;
  }

  public Single<CheckList> rxHealthStateWithOptions(HealthState healthState, CheckQueryOptions checkQueryOptions) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthStateWithOptions(healthState, checkQueryOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthServiceNodes(String service, boolean passing, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  public Single<ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthServiceNodes(service, passing, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  public Single<ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthServiceNodesWithOptions(service, passing, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServiceNodes(String service, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogServiceNodes(String service) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodes(service, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServiceNodesWithOptions(String service, ServiceQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogServiceNodesWithOptions(String service, ServiceQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodesWithOptions(service, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  public Single<List<String>> rxCatalogDatacenters() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogDatacenters(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodes(Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  public Single<NodeList> rxCatalogNodes() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodes(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodesWithOptions(NodeQueryOptions options, Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  public Single<NodeList> rxCatalogNodesWithOptions(NodeQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServices(Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogServices() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServices(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServicesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogServicesWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServicesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService localServices(Handler<AsyncResult<List<Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  public Single<List<Service>> rxLocalServices() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      localServices(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodeServices(String node, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogNodeServices(String node) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodeServices(node, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodeServicesWithOptions(String node, BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  public Single<ServiceList> rxCatalogNodeServicesWithOptions(String node, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodeServicesWithOptions(node, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService localChecks(Handler<AsyncResult<List<Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  public Single<List<Check>> rxLocalChecks() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      localChecks(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService registerCheck(CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  public Completable rxRegisterCheck(CheckOptions checkOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      registerCheck(checkOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxDeregisterCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deregisterCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxPassCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      passCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxPassCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      passCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxWarnCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      warnCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxWarnCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      warnCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxFailCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      failCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxFailCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      failCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateCheck(String checkId, CheckStatus status, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  public Completable rxUpdateCheck(String checkId, CheckStatus status) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateCheck(checkId, status, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateCheckWithNote(String checkId, CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  public Completable rxUpdateCheckWithNote(String checkId, CheckStatus status, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateCheckWithNote(checkId, status, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService leaderStatus(Handler<AsyncResult<String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  public Single<String> rxLeaderStatus() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      leaderStatus(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService peersStatus(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  public Single<List<String>> rxPeersStatus() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      peersStatus(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createSession(Handler<AsyncResult<String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  public Single<String> rxCreateSession() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSession(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createSessionWithOptions(SessionOptions options, Handler<AsyncResult<String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  public Single<String> rxCreateSessionWithOptions(SessionOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSessionWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  public Single<Session> rxInfoSession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoSession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoSessionWithOptions(String id, BlockingQueryOptions options, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  public Single<Session> rxInfoSessionWithOptions(String id, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoSessionWithOptions(id, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService renewSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  public Single<Session> rxRenewSession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      renewSession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listSessions(Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  public Single<SessionList> rxListSessions() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listSessions(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listSessionsWithOptions(BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  public Single<SessionList> rxListSessionsWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listSessionsWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listNodeSessions(String nodeId, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  public Single<SessionList> rxListNodeSessions(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listNodeSessions(nodeId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  public Single<SessionList> rxListNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listNodeSessionsWithOptions(nodeId, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService destroySession(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  public Completable rxDestroySession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      destroySession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createPreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  public Single<String> rxCreatePreparedQuery(PreparedQueryDefinition definition) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createPreparedQuery(definition, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getPreparedQuery(String id, Handler<AsyncResult<PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  public Single<PreparedQueryDefinition> rxGetPreparedQuery(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getPreparedQuery(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  public Single<List<PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getAllPreparedQueries(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updatePreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  public Completable rxUpdatePreparedQuery(PreparedQueryDefinition definition) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updatePreparedQuery(definition, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  public Completable rxDeletePreparedQuery(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deletePreparedQuery(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService executePreparedQuery(String query, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executePreparedQuery(query, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executePreparedQueryWithOptions(query, options, handler);
    });
  }

  public void close() { 
    delegate.close();
  }


  public static  ConsulService newInstance(io.vertx.ext.consul.ConsulService arg) {
    return arg != null ? new ConsulService(arg) : null;
  }
}
