/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.mongo.MongoService.class)
public class MongoService extends io.vertx.reactivex.ext.mongo.MongoClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoService that = (MongoService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MongoService> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MongoService((io.vertx.ext.mongo.MongoService) obj),
    MongoService::getDelegate
  );

  private final io.vertx.ext.mongo.MongoService delegate;
  
  public MongoService(io.vertx.ext.mongo.MongoService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.mongo.MongoService getDelegate() {
    return delegate;
  }

  /**
   * Create a proxy to a service that is deployed somewhere on the event bus
   * @param vertx the Vert.x instance
   * @param address the address the service is listening on on the event bus
   * @return the service
   */
  public static io.vertx.reactivex.ext.mongo.MongoService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.mongo.MongoService ret = io.vertx.reactivex.ext.mongo.MongoService.newInstance(io.vertx.ext.mongo.MongoService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.mongo.MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  public Maybe<String> rxSave(String collection, JsonObject document) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      save(collection, document, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Maybe<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      saveWithOptions(collection, document, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  public Maybe<String> rxInsert(String collection, JsonObject document) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      insert(collection, document, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Maybe<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      insertWithOptions(collection, document, writeOption, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.update(collection, query, update, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxUpdate(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      update(collection, query, update, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      updateCollection(collection, query, update, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateWithOptions(collection, query, update, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      updateCollectionWithOptions(collection, query, update, options, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replace(collection, query, replace, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxReplace(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      replace(collection, query, replace, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  public Maybe<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replaceDocuments(collection, query, replace, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replaceWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      replaceWithOptions(collection, query, replace, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  public Maybe<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replaceDocumentsWithOptions(collection, query, replace, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  public Maybe<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bulkWrite(collection, operations, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  public Maybe<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFind(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      find(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      findWithOptions(collection, query, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOne(collection, query, fields, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdate(collection, query, update, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplace(collection, query, replace, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDelete(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  public Single<Long> rxCount(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      count(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.remove(collection, query, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemove(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      remove(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  public Maybe<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocuments(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Maybe<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentsWithOptions(collection, query, writeOption, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOne(collection, query, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveOne(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeOne(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  public Maybe<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocument(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOneWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveOneWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeOneWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Maybe<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  public Completable rxCreateCollection(String collectionName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createCollection(collectionName, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  public Single<List<String>> rxGetCollections() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getCollections(handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  public Completable rxDropCollection(String collection) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      dropCollection(collection, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  public Completable rxCreateIndex(String collection, JsonObject key) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createIndex(collection, key, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createIndexWithOptions(collection, key, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  public Single<JsonArray> rxListIndexes(String collection) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listIndexes(collection, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  public Completable rxDropIndex(String collection, String indexName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      dropIndex(collection, indexName, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxRunCommand(String commandName, JsonObject command) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      runCommand(commandName, command, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      distinct(collection, fieldName, resultClassname, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, handler);
    });
  }

  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoService.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoService.DEFAULT_DB_NAME;

  public static  MongoService newInstance(io.vertx.ext.mongo.MongoService arg) {
    return arg != null ? new MongoService(arg) : null;
  }
}
