/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.validation;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * Base interface for validation.
 * For basic HTTP Request Validator, use {@link io.vertx.reactivex.ext.web.api.validation.HTTPRequestValidationHandler}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.ValidationHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.api.validation.ValidationHandler.class)
public interface ValidationHandler extends io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  io.vertx.ext.web.api.validation.ValidationHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event);


  public static  ValidationHandler newInstance(io.vertx.ext.web.api.validation.ValidationHandler arg) {
    return arg != null ? new ValidationHandlerImpl(arg) : null;
  }
}

class ValidationHandlerImpl implements ValidationHandler {
  private final io.vertx.ext.web.api.validation.ValidationHandler delegate;
  
  public ValidationHandlerImpl(io.vertx.ext.web.api.validation.ValidationHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.api.validation.ValidationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

}
