/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.common.template;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Map;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A template template uses a specific template and the data in a routing context to render a resource into a buffer.
 * <p>
 * Concrete implementations exist for several well-known template engines.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.common.template.TemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.common.template.TemplateEngine.class)
public class TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateEngine that = (TemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<TemplateEngine> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new TemplateEngine((io.vertx.ext.web.common.template.TemplateEngine) obj),
    TemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.common.template.TemplateEngine delegate;
  
  public TemplateEngine(io.vertx.ext.web.common.template.TemplateEngine delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.common.template.TemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  public void render(JsonObject context, String templateFileName, Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return 
   */
  public Single<io.vertx.reactivex.core.buffer.Buffer> rxRender(JsonObject context, String templateFileName) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      render(context, templateFileName, handler);
    });
  }

  /**
   * Returns true if the template template caches template files. If false, then template files are freshly loaded each
   * time they are used.
   * @return True if template files are cached; otherwise, false.
   */
  public boolean isCachingEnabled() { 
    boolean ret = delegate.isCachingEnabled();
    return ret;
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  public void render(Map<String, Object> context, String templateFileName, Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return 
   */
  public Single<io.vertx.reactivex.core.buffer.Buffer> rxRender(Map<String, Object> context, String templateFileName) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      render(context, templateFileName, handler);
    });
  }


  public static  TemplateEngine newInstance(io.vertx.ext.web.common.template.TemplateEngine arg) {
    return arg != null ? new TemplateEngine(arg) : null;
  }
}
